/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Optional;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.core.loading.ImmutableCatalogRequest;

@ValueClass
public abstract class CatalogRequest {
    public final String username() {
        return this.usernameOverride().orElseGet(this::requestingUsername);
    }

    public abstract String databaseName();

    public final boolean restrictSearchToUsernameCatalog() {
        return !this.requesterIsAdmin() || !this.usernameOverride().isEmpty();
    }

    abstract String requestingUsername();

    abstract Optional<String> usernameOverride();

    abstract boolean requesterIsAdmin();

    @Value.Check
    final void validate() {
        if (!this.requesterIsAdmin() && this.usernameOverride().isPresent()) {
            throw new IllegalStateException("Cannot override the username as a non-admin");
        }
    }

    public static CatalogRequest of(String username, String databaseName) {
        return ImmutableCatalogRequest.of(databaseName, username, Optional.empty(), false);
    }

    public static CatalogRequest of(String username, DatabaseId databaseId) {
        return CatalogRequest.of(username, databaseId.databaseName());
    }

    public static CatalogRequest ofAdmin(String username, String databaseName) {
        return CatalogRequest.ofAdmin(username, Optional.empty(), databaseName);
    }

    public static CatalogRequest ofAdmin(String username, Optional<String> usernameOverride, String databaseName) {
        return ImmutableCatalogRequest.of(databaseName, username, usernameOverride, true);
    }

    public static CatalogRequest ofAdmin(String username, DatabaseId databaseId) {
        return CatalogRequest.ofAdmin(username, databaseId.databaseName());
    }

    public static CatalogRequest ofAdmin(String username, Optional<String> usernameOverride, DatabaseId databaseId) {
        return CatalogRequest.ofAdmin(username, usernameOverride, databaseId.databaseName());
    }
}

