/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.ValueTypes;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphPropertyStore;
import org.neo4j.gds.api.properties.nodes.NodeProperty;
import org.neo4j.gds.api.properties.nodes.NodePropertyStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.GraphStoreBuilder;
import org.neo4j.gds.core.loading.IdMapAndProperties;
import org.neo4j.gds.core.loading.ImmutableStaticCapabilities;
import org.neo4j.gds.core.loading.RelationshipsAndProperties;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.values.storable.NumberType;

public final class CSRGraphStoreUtil {
    public static CSRGraphStore createFromGraph(DatabaseId databaseId, HugeGraph graph, String relationshipTypeString, Optional<String> relationshipPropertyKey, int concurrency) {
        RelationshipType relationshipType = RelationshipType.of((String)relationshipTypeString);
        Relationships relationships = graph.relationships();
        Orientation orientation = graph.relationshipTopology().orientation();
        RelationshipSchema.Builder relationshipSchemaBuilder = RelationshipSchema.builder().addRelationshipType(relationshipType, orientation);
        relationshipPropertyKey.ifPresent(property -> {
            if (!graph.hasRelationshipProperty()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected relationship property '%s', but graph has none.", (Object[])new Object[]{property}));
            }
            relationshipSchemaBuilder.addProperty(relationshipType, orientation, property, ValueType.DOUBLE);
        });
        Map<RelationshipType, Relationships.Topology> topology = Map.of(relationshipType, relationships.topology());
        NodePropertyStore nodeProperties = CSRGraphStoreUtil.constructNodePropertiesFromGraph(graph);
        Map<RelationshipType, RelationshipPropertyStore> relationshipProperties = CSRGraphStoreUtil.constructRelationshipPropertiesFromGraph(graph, relationshipPropertyKey, relationships, relationshipType);
        GraphSchema schema = GraphSchema.of((NodeSchema)graph.schema().nodeSchema(), (RelationshipSchema)relationshipSchemaBuilder.build(), Map.of());
        return new CSRGraphStore(databaseId, ImmutableStaticCapabilities.of(false), schema, graph.idMap(), nodeProperties, topology, relationshipProperties, GraphPropertyStore.empty(), concurrency);
    }

    @NotNull
    private static NodePropertyStore constructNodePropertiesFromGraph(HugeGraph graph) {
        NodePropertyStore.Builder nodePropertyStoreBuilder = NodePropertyStore.builder();
        graph.schema().nodeSchema().unionProperties().forEach((propertyKey, propertySchema) -> nodePropertyStoreBuilder.putIfAbsent((String)propertyKey, NodeProperty.of(propertyKey, propertySchema.state(), graph.nodeProperties((String)propertyKey), propertySchema.defaultValue())));
        return nodePropertyStoreBuilder.build();
    }

    @NotNull
    private static Map<RelationshipType, RelationshipPropertyStore> constructRelationshipPropertiesFromGraph(Graph graph, Optional<String> relationshipProperty, Relationships relationships, RelationshipType relationshipType) {
        Map<RelationshipType, RelationshipPropertyStore> relationshipProperties = Collections.emptyMap();
        if (relationshipProperty.isPresent() && relationships.properties().isPresent()) {
            Map relationshipPropertySchemas = (Map)graph.schema().relationshipSchema().properties().get(relationshipType);
            if (relationshipPropertySchemas.size() != 1) {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Relationship schema is expected to have exactly one property but had %s", (Object[])new Object[]{relationshipPropertySchemas.size()}));
            }
            RelationshipPropertySchema relationshipPropertySchema = (RelationshipPropertySchema)relationshipPropertySchemas.values().stream().findFirst().orElseThrow();
            String propertyKey = relationshipProperty.get();
            relationshipProperties = Collections.singletonMap(relationshipType, RelationshipPropertyStore.builder().putIfAbsent(propertyKey, RelationshipProperty.of(propertyKey, NumberType.FLOATING_POINT, relationshipPropertySchema.state(), relationships.properties().orElseThrow(), relationshipPropertySchema.defaultValue().isUserDefined() ? relationshipPropertySchema.defaultValue() : ValueTypes.fromNumberType(NumberType.FLOATING_POINT).fallbackValue(), relationshipPropertySchema.aggregation())).build());
        }
        return relationshipProperties;
    }

    public static void extractNodeProperties(GraphStoreBuilder graphStoreBuilder, Function<String, PropertySchema> nodeSchema, Map<String, NodePropertyValues> nodeProperties) {
        NodePropertyStore.Builder propertyStoreBuilder = NodePropertyStore.builder();
        nodeProperties.forEach((propertyKey, propertyValues) -> {
            PropertySchema propertySchema = (PropertySchema)nodeSchema.apply((String)propertyKey);
            propertyStoreBuilder.putIfAbsent((String)propertyKey, NodeProperty.of(propertyKey, propertySchema.state(), propertyValues, propertySchema.defaultValue()));
        });
        graphStoreBuilder.nodePropertyStore(propertyStoreBuilder.build());
    }

    public static RelationshipPropertyStore buildRelationshipPropertyStore(List<Relationships> relationships, List<RelationshipPropertySchema> relationshipPropertySchemas) {
        assert (relationships.size() >= relationshipPropertySchemas.size());
        RelationshipPropertyStore.Builder propertyStoreBuilder = RelationshipPropertyStore.builder();
        for (int i = 0; i < relationshipPropertySchemas.size(); ++i) {
            Relationships relationship = relationships.get(i);
            RelationshipPropertySchema relationshipPropertySchema = relationshipPropertySchemas.get(i);
            relationship.properties().ifPresent(properties -> propertyStoreBuilder.putIfAbsent(relationshipPropertySchema.key(), RelationshipProperty.of(relationshipPropertySchema.key(), NumberType.FLOATING_POINT, relationshipPropertySchema.state(), properties, relationshipPropertySchema.defaultValue(), relationshipPropertySchema.aggregation())));
        }
        return propertyStoreBuilder.build();
    }

    public static GraphSchema computeGraphSchema(IdMapAndProperties idMapAndProperties, Function<NodeLabel, Collection<String>> propertiesByLabel, RelationshipsAndProperties relationshipsAndProperties) {
        Map properties = idMapAndProperties.properties().properties();
        NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder();
        for (NodeLabel label : idMapAndProperties.idMap().availableNodeLabels()) {
            for (String propertyKey : propertiesByLabel.apply(label)) {
                nodeSchemaBuilder.addProperty(label, propertyKey, ((NodeProperty)properties.get(propertyKey)).propertySchema());
            }
        }
        idMapAndProperties.idMap().availableNodeLabels().forEach(arg_0 -> ((NodeSchema.Builder)nodeSchemaBuilder).addLabel(arg_0));
        RelationshipSchema.Builder relationshipSchemaBuilder = RelationshipSchema.builder();
        relationshipsAndProperties.properties().forEach((relType, propertyStore) -> propertyStore.relationshipProperties().forEach((propertyKey, propertyValues) -> relationshipSchemaBuilder.addProperty(relType, relationshipsAndProperties.relationships().get(relType).orientation(), propertyKey, propertyValues.propertySchema())));
        relationshipsAndProperties.relationships().keySet().forEach(type -> relationshipSchemaBuilder.addRelationshipType(type, relationshipsAndProperties.relationships().get(type).orientation()));
        return GraphSchema.of((NodeSchema)nodeSchemaBuilder.build(), (RelationshipSchema)relationshipSchemaBuilder.build(), Map.of());
    }

    private CSRGraphStoreUtil() {
    }
}

