/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.FilteredIdMap;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.ValueTypes;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.graph.GraphProperty;
import org.neo4j.gds.api.properties.graph.GraphPropertyStore;
import org.neo4j.gds.api.properties.graph.GraphPropertyValues;
import org.neo4j.gds.api.properties.nodes.NodeProperty;
import org.neo4j.gds.api.properties.nodes.NodePropertyStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.api.schema.NodeSchema;
import org.neo4j.gds.api.schema.PropertySchema;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.StringSimilarity;
import org.neo4j.gds.core.huge.CSRCompositeRelationshipIterator;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.huge.NodeFilteredGraph;
import org.neo4j.gds.core.huge.UnionGraph;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.DeletionResult;
import org.neo4j.gds.core.utils.TimeUtil;
import org.neo4j.gds.utils.ExceptionUtil;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.values.storable.NumberType;

@Value.Style(typeBuilder="GraphStoreBuilder")
public class CSRGraphStore
implements GraphStore {
    private final int concurrency;
    private final DatabaseId databaseId;
    private final Capabilities capabilities;
    private final IdMap nodes;
    private final Map<RelationshipType, Relationships.Topology> relationships;
    private final Map<RelationshipType, RelationshipPropertyStore> relationshipProperties;
    private final Set<Graph> createdGraphs;
    private GraphSchema schema;
    private GraphPropertyStore graphProperties;
    private NodePropertyStore nodeProperties;
    private ZonedDateTime modificationTime;

    @Builder.Factory
    public static CSRGraphStore of(DatabaseId databaseId, Capabilities capabilities, GraphSchema schema, IdMap nodes, @Nullable NodePropertyStore nodePropertyStore, Map<RelationshipType, Relationships.Topology> relationships, Map<RelationshipType, RelationshipPropertyStore> relationshipPropertyStores, Optional<GraphPropertyStore> graphProperties, int concurrency) {
        return new CSRGraphStore(databaseId, capabilities, schema, nodes, nodePropertyStore == null ? NodePropertyStore.empty() : nodePropertyStore, relationships, relationshipPropertyStores, graphProperties.orElseGet(GraphPropertyStore::empty), concurrency);
    }

    protected CSRGraphStore(DatabaseId databaseId, Capabilities capabilities, GraphSchema schema, IdMap nodes, NodePropertyStore nodeProperties, Map<RelationshipType, Relationships.Topology> relationships, Map<RelationshipType, RelationshipPropertyStore> relationshipProperties, GraphPropertyStore graphProperties, int concurrency) {
        this.databaseId = databaseId;
        this.capabilities = capabilities;
        this.schema = schema;
        this.graphProperties = graphProperties;
        this.nodes = nodes;
        this.nodeProperties = nodeProperties;
        this.relationships = new HashMap<RelationshipType, Relationships.Topology>(relationships);
        this.relationshipProperties = new HashMap<RelationshipType, RelationshipPropertyStore>(relationshipProperties);
        this.concurrency = concurrency;
        this.createdGraphs = new HashSet<Graph>();
        this.modificationTime = TimeUtil.now();
    }

    @Override
    public DatabaseId databaseId() {
        return this.databaseId;
    }

    @Override
    public GraphSchema schema() {
        return this.schema;
    }

    @Override
    public ZonedDateTime modificationTime() {
        return this.modificationTime;
    }

    @Override
    public Capabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public Set<String> graphPropertyKeys() {
        return this.graphProperties.keySet();
    }

    @Override
    public boolean hasGraphProperty(String propertyKey) {
        return this.graphPropertyKeys().contains(propertyKey);
    }

    @Override
    public GraphProperty graphProperty(String propertyKey) {
        return (GraphProperty)this.graphProperties.get(propertyKey);
    }

    @Override
    public ValueType graphPropertyType(String propertyKey) {
        return this.graphProperty(propertyKey).valueType();
    }

    @Override
    public GraphPropertyValues graphPropertyValues(String propertyKey) {
        return (GraphPropertyValues)this.graphProperty(propertyKey).values();
    }

    @Override
    public void addGraphProperty(String propertyKey, GraphPropertyValues propertyValues) {
        this.updateGraphStore(graphStore -> {
            if (graphStore.hasGraphProperty(propertyKey)) {
                throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Graph property %s already exists", (Object[])new Object[]{propertyKey}));
            }
            graphStore.graphProperties = GraphPropertyStore.builder().from(graphStore.graphProperties).putIfAbsent(propertyKey, GraphProperty.of(propertyKey, propertyValues)).build();
            HashMap<String, PropertySchema> newGraphPropertySchema = new HashMap<String, PropertySchema>(this.schema().graphProperties());
            newGraphPropertySchema.put(propertyKey, PropertySchema.of((String)propertyKey, (ValueType)propertyValues.valueType()));
            this.schema = GraphSchema.of((NodeSchema)this.schema().nodeSchema(), (RelationshipSchema)this.schema().relationshipSchema(), newGraphPropertySchema);
        });
    }

    @Override
    public void removeGraphProperty(String propertyKey) {
        this.updateGraphStore(graphStore -> {
            graphStore.graphProperties = GraphPropertyStore.builder().from(graphStore.graphProperties).removeProperty(propertyKey).build();
            HashMap newGraphPropertySchema = new HashMap(this.schema().graphProperties());
            newGraphPropertySchema.remove(propertyKey);
            this.schema = GraphSchema.of((NodeSchema)this.schema().nodeSchema(), (RelationshipSchema)this.schema().relationshipSchema(), newGraphPropertySchema);
        });
    }

    @Override
    public IdMap nodes() {
        return this.nodes;
    }

    @Override
    public Set<NodeLabel> nodeLabels() {
        assert (this.schema().nodeSchema().availableLabels().size() == this.nodes.availableNodeLabels().size());
        return this.nodes.availableNodeLabels();
    }

    @Override
    public Set<String> nodePropertyKeys(NodeLabel label) {
        return this.schema().nodeSchema().properties().getOrDefault(label, Map.of()).keySet();
    }

    @Override
    public Set<String> nodePropertyKeys() {
        assert (this.schema().nodeSchema().allProperties().size() == this.nodeProperties.keySet().size());
        return this.nodeProperties.keySet();
    }

    @Override
    public boolean hasNodeProperty(String propertyKey) {
        return this.nodeProperties.containsKey(propertyKey);
    }

    @Override
    public boolean hasNodeProperty(NodeLabel label, String propertyKey) {
        return this.schema().nodeSchema().hasProperty((ElementIdentifier)label, propertyKey) && this.hasNodeProperty(propertyKey);
    }

    @Override
    public boolean hasNodeProperty(Collection<NodeLabel> labels, String propertyKey) {
        return labels.stream().allMatch(label -> this.hasNodeProperty((NodeLabel)label, propertyKey));
    }

    @Override
    public void addNodeProperty(Set<NodeLabel> labels, String propertyKey, NodePropertyValues propertyValues) {
        this.updateGraphStore(graphStore -> {
            if (graphStore.hasNodeProperty(propertyKey)) {
                throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Node property %s already exists", (Object[])new Object[]{propertyKey}));
            }
            graphStore.nodeProperties = NodePropertyStore.builder().from(graphStore.nodeProperties).putIfAbsent(propertyKey, NodeProperty.of(propertyKey, PropertyState.TRANSIENT, propertyValues)).build();
            NodeSchema.Builder schemaBuilder = NodeSchema.builder().from(this.schema().nodeSchema());
            labels.forEach(label -> schemaBuilder.addProperty(label, propertyKey, PropertySchema.of((String)propertyKey, (ValueType)propertyValues.valueType(), (DefaultValue)propertyValues.valueType().fallbackValue(), (PropertyState)PropertyState.TRANSIENT)));
            this.schema = GraphSchema.of((NodeSchema)schemaBuilder.build(), (RelationshipSchema)this.schema().relationshipSchema(), (Map)this.schema.graphProperties());
        });
    }

    @Override
    public void removeNodeProperty(String propertyKey) {
        this.updateGraphStore(graphStore -> {
            graphStore.nodeProperties = NodePropertyStore.builder().from(graphStore.nodeProperties).removeProperty(propertyKey).build();
            NodeSchema.Builder nodeSchemaBuilder = NodeSchema.builder().from(this.schema().nodeSchema()).removeProperty(propertyKey);
            this.schema = GraphSchema.of((NodeSchema)nodeSchemaBuilder.build(), (RelationshipSchema)this.schema().relationshipSchema(), (Map)this.schema.graphProperties());
        });
    }

    @Override
    public NodeProperty nodeProperty(String propertyKey) {
        return (NodeProperty)this.nodeProperties.get(propertyKey);
    }

    @Override
    public Set<RelationshipType> relationshipTypes() {
        return this.relationships.keySet();
    }

    @Override
    public boolean hasRelationshipType(RelationshipType relationshipType) {
        return this.relationships.containsKey(relationshipType);
    }

    @Override
    public long relationshipCount() {
        long sum = 0L;
        for (Relationships.Topology topology : this.relationships.values()) {
            long elementCount = topology.elementCount();
            sum += elementCount;
        }
        return sum;
    }

    @Override
    public long relationshipCount(RelationshipType relationshipType) {
        return this.relationships.get(relationshipType).elementCount();
    }

    @Override
    public boolean hasRelationshipProperty(RelationshipType relType, String propertyKey) {
        return this.relationshipProperties.containsKey(relType) && this.relationshipProperties.get(relType).containsKey(propertyKey);
    }

    @Override
    public ValueType relationshipPropertyType(String propertyKey) {
        return this.relationshipProperties.values().stream().filter(propertyStore -> propertyStore.containsKey(propertyKey)).map(propertyStore -> propertyStore.get(propertyKey).valueType()).findFirst().orElse(ValueType.UNKNOWN);
    }

    @Override
    public Set<String> relationshipPropertyKeys() {
        return this.relationshipProperties.values().stream().flatMap(relationshipPropertyStore -> relationshipPropertyStore.keySet().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> relationshipPropertyKeys(RelationshipType relationshipType) {
        return this.relationshipProperties.getOrDefault(relationshipType, RelationshipPropertyStore.empty()).keySet();
    }

    @Override
    public RelationshipProperty relationshipPropertyValues(RelationshipType relationshipType, String propertyKey) {
        return this.relationshipProperties.getOrDefault(relationshipType, RelationshipPropertyStore.empty()).get(propertyKey);
    }

    @Override
    public void addRelationshipType(RelationshipType relationshipType, Optional<String> relationshipPropertyKey, Optional<NumberType> relationshipPropertyType, Relationships relationships) {
        this.updateGraphStore(graphStore -> {
            if (!this.hasRelationshipType(relationshipType)) {
                RelationshipSchema.Builder newSchemaBuilder = RelationshipSchema.builder();
                graphStore.relationships.put(relationshipType, relationships.topology());
                Orientation orientation = relationships.topology().orientation();
                newSchemaBuilder.addRelationshipType(relationshipType, orientation);
                if (relationshipPropertyKey.isPresent() && relationshipPropertyType.isPresent() && relationships.properties().isPresent()) {
                    this.addRelationshipProperty(relationshipType, (String)relationshipPropertyKey.get(), (NumberType)relationshipPropertyType.get(), relationships.properties().get(), (CSRGraphStore)graphStore);
                    ValueType valueType = ValueTypes.fromNumberType((NumberType)relationshipPropertyType.get());
                    newSchemaBuilder.addProperty(relationshipType, orientation, (String)relationshipPropertyKey.get(), RelationshipPropertySchema.of((String)((String)relationshipPropertyKey.get()), (ValueType)valueType, (DefaultValue)valueType.fallbackValue(), (PropertyState)PropertyState.TRANSIENT, (Aggregation)Aggregation.NONE));
                }
                RelationshipSchema resultingRelationshipSchema = this.schema.relationshipSchema().union(newSchemaBuilder.build());
                this.schema = GraphSchema.of((NodeSchema)this.schema().nodeSchema(), (RelationshipSchema)resultingRelationshipSchema, (Map)this.schema.graphProperties());
            }
        });
    }

    @Override
    public DeletionResult deleteRelationships(RelationshipType relationshipType) {
        return DeletionResult.of(builder -> this.updateGraphStore(graphStore -> {
            Relationships.Topology removedTopology = graphStore.relationships.remove(relationshipType);
            builder.deletedRelationships(removedTopology == null ? 0L : removedTopology.elementCount());
            RelationshipPropertyStore removedProperties = graphStore.relationshipProperties.remove(relationshipType);
            if (removedProperties != null) {
                removedProperties.relationshipProperties().values().forEach(property -> builder.putDeletedProperty(property.key(), property.values().elementCount()));
            }
            RelationshipSchema relationshipSchema = RelationshipSchema.builder().from(this.schema().relationshipSchema()).removeRelationshipType(relationshipType).build();
            this.schema = GraphSchema.of((NodeSchema)this.schema().nodeSchema(), (RelationshipSchema)relationshipSchema, (Map)this.schema.graphProperties());
        }));
    }

    @Override
    public CSRGraph getGraph(Collection<NodeLabel> nodeLabels) {
        return this.getGraph((Collection)nodeLabels, (Collection)List.of(), Optional.empty());
    }

    @Override
    public CSRGraph getGraph(Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        this.validateInput(relationshipTypes, maybeRelationshipProperty);
        if (relationshipTypes.isEmpty()) {
            return this.createNodeOnlyGraph(nodeLabels);
        }
        return this.createGraph(nodeLabels, relationshipTypes, maybeRelationshipProperty);
    }

    @Override
    public CSRGraph getUnion() {
        if (this.relationships.isEmpty()) {
            return this.getGraph(this.nodeLabels());
        }
        List graphs = this.relationships.keySet().stream().flatMap(relationshipType -> {
            if (this.relationshipProperties.containsKey(relationshipType) && !this.relationshipProperties.get(relationshipType).isEmpty()) {
                return this.relationshipProperties.get(relationshipType).keySet().stream().map(propertyKey -> this.createGraph((Collection<NodeLabel>)this.nodeLabels(), (RelationshipType)relationshipType, Optional.of(propertyKey)));
            }
            return Stream.of(this.createGraph((Collection<NodeLabel>)this.nodeLabels(), (RelationshipType)relationshipType, Optional.empty()));
        }).collect(Collectors.toList());
        return UnionGraph.of(graphs);
    }

    @Override
    public void canRelease(boolean canRelease) {
        this.createdGraphs.forEach(graph -> graph.canRelease(canRelease));
    }

    @Override
    public CompositeRelationshipIterator getCompositeRelationshipIterator(RelationshipType relationshipType, List<String> propertyKeys) {
        if (!this.relationshipTypes().contains(relationshipType)) {
            throw new IllegalArgumentException(StringSimilarity.prettySuggestions((String)StringFormatting.formatWithLocale((String)"Unknown relationship type `%s`.", (Object[])new Object[]{relationshipType}), (CharSequence)relationshipType.name(), (Collection)this.relationshipTypes().stream().map(ElementIdentifier::name).collect(Collectors.toSet())));
        }
        Set<String> availableProperties = this.relationshipPropertyKeys(relationshipType);
        if (!availableProperties.containsAll(propertyKeys)) {
            List missingPropertyKeys = propertyKeys.stream().filter(propertyKey -> !availableProperties.contains(propertyKey)).collect(Collectors.toList());
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Missing property keys %s for relationship type %s. Available property keys are %s", (Object[])new Object[]{StringJoining.join(missingPropertyKeys), relationshipType.name, StringJoining.join(availableProperties)}));
        }
        AdjacencyList adjacencyList = this.relationships.get(relationshipType).adjacencyList();
        RelationshipPropertyStore relationshipPropertyStore = this.relationshipProperties.get(relationshipType);
        AdjacencyProperties[] properties = propertyKeys.isEmpty() ? CSRCompositeRelationshipIterator.EMPTY_PROPERTIES : (AdjacencyProperties[])propertyKeys.stream().map(relationshipPropertyStore::get).map(RelationshipProperty::values).map(Relationships.Properties::propertiesList).toArray(AdjacencyProperties[]::new);
        return new CSRCompositeRelationshipIterator(adjacencyList, propertyKeys.toArray(new String[0]), properties);
    }

    @Override
    public void release() {
        this.createdGraphs.forEach(Graph::release);
        this.releaseInternals();
    }

    private void releaseInternals() {
        Stream.Builder<AutoCloseable> closeables = Stream.builder();
        if (this.nodes instanceof AutoCloseable) {
            closeables.accept((AutoCloseable)((Object)this.nodes));
        }
        this.relationships.values().forEach(rel -> closeables.add(rel.adjacencyList()));
        this.relationshipProperties.forEach((propertyName, properties) -> properties.values().forEach(prop -> closeables.add(prop.values().propertiesList())));
        ExceptionUtil.closeAll(ExceptionUtil.RETHROW_UNCHECKED, closeables.build().distinct());
    }

    @Override
    public long nodeCount() {
        return this.nodes.nodeCount();
    }

    private synchronized void updateGraphStore(Consumer<CSRGraphStore> updateFunction) {
        updateFunction.accept(this);
        this.modificationTime = TimeUtil.now();
    }

    private void addRelationshipProperty(RelationshipType relationshipType, String propertyKey, NumberType propertyType, Relationships.Properties properties, CSRGraphStore graphStore) {
        graphStore.relationshipProperties.compute(relationshipType, (relType, propertyStore) -> {
            RelationshipPropertyStore.Builder builder = RelationshipPropertyStore.builder();
            if (propertyStore != null) {
                builder.from((RelationshipPropertyStore)propertyStore);
            }
            return builder.putIfAbsent(propertyKey, RelationshipProperty.of(propertyKey, propertyType, PropertyState.TRANSIENT, properties, ValueTypes.fromNumberType(propertyType).fallbackValue(), Aggregation.NONE)).build();
        });
    }

    private CSRGraph createGraph(Collection<NodeLabel> nodeLabels, RelationshipType relationshipType, Optional<String> maybeRelationshipProperty) {
        Optional<? extends FilteredIdMap> filteredNodes = this.getFilteredIdMap(nodeLabels);
        Map<String, NodePropertyValues> filteredNodeProperties = this.filterNodeProperties(nodeLabels);
        NodeSchema nodeSchema = this.schema().nodeSchema().filter(new HashSet<NodeLabel>(nodeLabels));
        return this.createGraphFromRelationshipType(filteredNodes, filteredNodeProperties, nodeSchema, relationshipType, maybeRelationshipProperty);
    }

    private CSRGraph createGraph(Collection<NodeLabel> filteredLabels, Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        Optional<? extends FilteredIdMap> filteredNodes = this.getFilteredIdMap(filteredLabels);
        Map<String, NodePropertyValues> filteredNodeProperties = this.filterNodeProperties(filteredLabels);
        NodeSchema nodeSchema = this.schema().nodeSchema().filter(new HashSet<NodeLabel>(filteredLabels));
        List<CSRGraph> filteredGraphs = this.relationships.keySet().stream().filter(relationshipTypes::contains).map(relationshipType -> this.createGraphFromRelationshipType(filteredNodes, filteredNodeProperties, nodeSchema, (RelationshipType)relationshipType, maybeRelationshipProperty)).collect(Collectors.toList());
        filteredGraphs.forEach(graph -> graph.canRelease(false));
        this.createdGraphs.addAll(filteredGraphs);
        return UnionGraph.of(filteredGraphs);
    }

    private CSRGraph createNodeOnlyGraph(Collection<NodeLabel> nodeLabels) {
        Optional<? extends FilteredIdMap> filteredNodes = this.getFilteredIdMap(nodeLabels);
        Map<String, NodePropertyValues> filteredNodeProperties = this.filterNodeProperties(nodeLabels);
        NodeSchema nodeSchema = this.schema().nodeSchema().filter(new HashSet<NodeLabel>(nodeLabels));
        GraphSchema graphSchema = GraphSchema.of((NodeSchema)nodeSchema, (RelationshipSchema)RelationshipSchema.empty(), (Map)this.schema.graphProperties());
        HugeGraph initialGraph = HugeGraph.create(this.nodes, graphSchema, filteredNodeProperties, Relationships.Topology.EMPTY, Optional.empty());
        return filteredNodes.isPresent() ? new NodeFilteredGraph(initialGraph, filteredNodes.get()) : initialGraph;
    }

    @NotNull
    private Optional<? extends FilteredIdMap> getFilteredIdMap(Collection<NodeLabel> filteredLabels) {
        boolean loadAllNodes = filteredLabels.containsAll(this.nodeLabels());
        return loadAllNodes || this.schema().nodeSchema().containsOnlyAllNodesLabel() ? Optional.empty() : this.nodes.withFilteredLabels(filteredLabels, this.concurrency);
    }

    private CSRGraph createGraphFromRelationshipType(Optional<? extends FilteredIdMap> filteredNodes, Map<String, NodePropertyValues> filteredNodeProperties, NodeSchema nodeSchema, RelationshipType relationshipType, Optional<String> maybeRelationshipProperty) {
        GraphSchema graphSchema = GraphSchema.of((NodeSchema)nodeSchema, (RelationshipSchema)this.schema().relationshipSchema().filter(Set.of(relationshipType)), (Map)this.schema.graphProperties());
        Relationships.Topology topology = this.relationships.get(relationshipType);
        Optional<Relationships.Properties> properties = maybeRelationshipProperty.map(propertyKey -> this.relationshipProperties.get(relationshipType).get((String)propertyKey).values());
        HugeGraph initialGraph = HugeGraph.create(this.nodes, graphSchema, filteredNodeProperties, topology, properties);
        return filteredNodes.isPresent() ? new NodeFilteredGraph(initialGraph, filteredNodes.get()) : initialGraph;
    }

    private Map<String, NodePropertyValues> filterNodeProperties(Collection<NodeLabel> labels) {
        if (this.nodeProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        if (labels.size() == 1 || this.schema().nodeSchema().containsOnlyAllNodesLabel()) {
            return this.nodeProperties.propertyValues();
        }
        return this.schema().nodeSchema().filter(new HashSet<NodeLabel>(labels)).allProperties().stream().collect(Collectors.toMap(Function.identity(), propertyKey -> (NodePropertyValues)this.nodeProperty((String)propertyKey).values()));
    }

    private void validateInput(Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        relationshipTypes.forEach(relationshipType -> {
            if (!this.relationships.containsKey(relationshipType)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No relationships have been loaded for relationship type '%s'", (Object[])new Object[]{relationshipType}));
            }
            maybeRelationshipProperty.ifPresent(relationshipProperty -> {
                if (!this.hasRelationshipProperty((RelationshipType)relationshipType, (String)relationshipProperty)) {
                    throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Property '%s' does not exist for relationships with type '%s'.", (Object[])new Object[]{maybeRelationshipProperty.get(), relationshipType}));
                }
            });
        });
    }
}

