/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.collections.PageUtil;

public final class BumpAllocator<PAGE> {
    public static final int PAGE_SHIFT = 18;
    public static final int PAGE_SIZE = 262144;
    public static final long PAGE_MASK = 262143L;
    private static final int NO_SKIP = -1;
    private static final VarHandle PAGES;
    private static final VarHandle ALLOCATED_PAGES;
    private volatile int allocatedPages;
    private volatile PAGE[] pages;
    private final Factory<PAGE> pageFactory;
    private final ReentrantLock growLock;

    BumpAllocator(Factory<PAGE> pageFactory) {
        this.pageFactory = pageFactory;
        this.growLock = new ReentrantLock(true);
        this.pages = pageFactory.newEmptyPages();
    }

    LocalAllocator<PAGE> newLocalAllocator() {
        return new LocalAllocator(this);
    }

    LocalPositionalAllocator<PAGE> newLocalPositionalAllocator() {
        return new LocalPositionalAllocator(this);
    }

    PAGE[] intoPages() {
        return this.pages;
    }

    private long insertDefaultSizedPage() {
        int pageIndex = ALLOCATED_PAGES.getAndAdd(this, 1);
        this.grow(pageIndex + 1, -1);
        return PageUtil.capacityFor((int)pageIndex, (int)18);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insertMultiplePages(int uptoPage, @Nullable PAGE page) {
        int newNumPages;
        int currentNumPages = ALLOCATED_PAGES.get(this);
        if (currentNumPages < (newNumPages = uptoPage + 1)) {
            int pageToSkip = page == null ? -1 : uptoPage;
            this.grow(newNumPages, pageToSkip);
        }
        if (page != null) {
            this.growLock.lock();
            try {
                this.pages[uptoPage] = page;
            }
            finally {
                this.growLock.unlock();
            }
        }
        while (currentNumPages < newNumPages) {
            int nextNumPages = ALLOCATED_PAGES.compareAndExchange(this, currentNumPages, newNumPages);
            if (nextNumPages == currentNumPages) {
                currentNumPages = newNumPages;
                break;
            }
            currentNumPages = nextNumPages;
        }
        return PageUtil.capacityFor((int)currentNumPages, (int)18);
    }

    private long insertExistingPage(@NotNull PAGE page) {
        int pageIndex = ALLOCATED_PAGES.getAndAdd(this, 1);
        this.grow(pageIndex + 1, pageIndex);
        this.growLock.lock();
        try {
            this.pages[pageIndex] = page;
        }
        finally {
            this.growLock.unlock();
        }
        return PageUtil.capacityFor((int)pageIndex, (int)18);
    }

    private void grow(int newNumPages, int skipPage) {
        if (this.capacityLeft(newNumPages)) {
            return;
        }
        this.growLock.lock();
        try {
            if (this.capacityLeft(newNumPages)) {
                return;
            }
            this.setPages(newNumPages, skipPage);
        }
        finally {
            this.growLock.unlock();
        }
    }

    private boolean capacityLeft(long newNumPages) {
        return newNumPages <= (long)this.pages.length;
    }

    private void setPages(int newNumPages, int skipPage) {
        PAGE[] currentPages = this.pages;
        Object[] newPages = Arrays.copyOf(currentPages, newNumPages);
        for (int i = currentPages.length; i < newNumPages; ++i) {
            if (i == skipPage) continue;
            newPages[i] = this.pageFactory.newPage(262144);
        }
        PAGES.set(this, newPages);
    }

    static {
        try {
            PAGES = MethodHandles.lookup().findVarHandle(BumpAllocator.class, "pages", Object[].class);
            ALLOCATED_PAGES = MethodHandles.lookup().findVarHandle(BumpAllocator.class, "allocatedPages", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static final class LocalPositionalAllocator<PAGE> {
        private final BumpAllocator<PAGE> globalAllocator;
        private long capacity;

        private LocalPositionalAllocator(BumpAllocator<PAGE> globalAllocator) {
            this.globalAllocator = globalAllocator;
            this.capacity = 0L;
        }

        public void insertAt(long offset, @NotNull PAGE page, int length) {
            int targetLength = this.globalAllocator.pageFactory.lengthOfPage(page);
            this.insertData(offset, page, Math.min(length, targetLength), this.capacity, targetLength);
        }

        private void insertData(long offset, @NotNull PAGE page, int length, long capacity, int targetsLength) {
            PAGE pageToInsert = page;
            if (offset + (long)length > capacity) {
                pageToInsert = this.allocateNewPages(offset, page, length, targetsLength);
            }
            if (pageToInsert != null) {
                int pageId = PageUtil.pageIndex((long)offset, (int)18);
                int pageOffset = PageUtil.indexInPage((long)offset, (long)262143L);
                Object allocatedPage = this.globalAllocator.pages[pageId];
                System.arraycopy(pageToInsert, 0, allocatedPage, pageOffset, length);
            }
        }

        @Nullable
        private PAGE allocateNewPages(long offset, @NotNull PAGE page, int length, int targetsLength) {
            int pageId = PageUtil.pageIndex((long)offset, (int)18);
            Object existingPage = null;
            if (length > 262144) {
                if (length < targetsLength) {
                    page = this.globalAllocator.pageFactory.copyOfPage(page, length);
                }
                existingPage = page;
            }
            this.capacity = this.globalAllocator.insertMultiplePages(pageId, existingPage);
            if (existingPage != null) {
                return null;
            }
            return page;
        }
    }

    static final class LocalAllocator<PAGE> {
        private final BumpAllocator<PAGE> globalAllocator;
        private long top;
        private PAGE page;
        private int offset;

        private LocalAllocator(BumpAllocator<PAGE> globalAllocator) {
            this.globalAllocator = globalAllocator;
            this.offset = 262144;
        }

        public long insert(@NotNull PAGE targets, int length) {
            int targetLength = this.globalAllocator.pageFactory.lengthOfPage(targets);
            return this.insertData(targets, Math.min(length, targetLength), this.top, targetLength);
        }

        private long insertData(@NotNull PAGE targets, int length, long address, int targetsLength) {
            int maxOffset = 262144 - length;
            if (maxOffset >= this.offset) {
                this.doAllocate(targets, length);
                return address;
            }
            return this.slowPathAllocate(targets, length, maxOffset, targetsLength);
        }

        private long slowPathAllocate(@NotNull PAGE targets, int length, int maxOffset, int targetsLength) {
            if (maxOffset < 0) {
                return this.oversizingAllocate(targets, length, targetsLength);
            }
            return this.prefetchAllocate(targets, length);
        }

        private long oversizingAllocate(@NotNull PAGE targets, int length, int targetsLength) {
            if (length < targetsLength) {
                targets = this.globalAllocator.pageFactory.copyOfPage(targets, length);
            }
            return this.globalAllocator.insertExistingPage(targets);
        }

        private long prefetchAllocate(@NotNull PAGE targets, int length) {
            long address = this.prefetchAllocate();
            this.doAllocate(targets, length);
            return address;
        }

        private long prefetchAllocate() {
            long address = this.top = this.globalAllocator.insertDefaultSizedPage();
            assert (PageUtil.indexInPage((long)address, (long)262143L) == 0);
            int currentPageIndex = PageUtil.pageIndex((long)address, (int)18);
            this.page = this.globalAllocator.pages[currentPageIndex];
            this.offset = 0;
            return address;
        }

        private void doAllocate(@NotNull PAGE targets, int length) {
            System.arraycopy(targets, 0, this.page, this.offset, length);
            this.offset += length;
            this.top += (long)length;
        }
    }

    public static interface Factory<PAGE> {
        public PAGE[] newEmptyPages();

        public PAGE newPage(int var1);

        public PAGE copyOfPage(PAGE var1, int var2);

        public int lengthOfPage(PAGE var1);
    }
}

