/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.collections.HugeSparseLongArray;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.ArrayIdMap;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class ArrayIdMapBuilderOps {
    static ArrayIdMap build(HugeLongArray graphIds, long nodeCount, LabelInformation.Builder labelInformationBuilder, long highestNodeId, int concurrency) {
        if (highestNodeId == -1L) {
            highestNodeId = graphIds.asNodeProperties().getMaxLongPropertyValue().orElse(-1L);
        }
        HugeSparseLongArray nodeToGraphIds = ArrayIdMapBuilderOps.buildSparseIdMap(nodeCount, highestNodeId, concurrency, graphIds);
        LabelInformation labelInformation = labelInformationBuilder.build(nodeCount, arg_0 -> ((HugeSparseLongArray)nodeToGraphIds).get(arg_0));
        return new ArrayIdMap(graphIds, nodeToGraphIds, labelInformation, nodeCount, highestNodeId);
    }

    @NotNull
    static HugeSparseLongArray buildSparseIdMap(long nodeCount, long highestNodeId, int concurrency, HugeLongArray graphIds) {
        HugeSparseLongArray.Builder idMapBuilder = HugeSparseLongArray.builder((long)-1L, (long)(highestNodeId + 1L));
        ParallelUtil.readParallel(concurrency, nodeCount, Pools.DEFAULT, (start, end) -> ArrayIdMapBuilderOps.addNodes(graphIds, idMapBuilder, start, end));
        return idMapBuilder.build();
    }

    private static void addNodes(HugeLongArray graphIds, HugeSparseLongArray.Builder builder, long startNode, long endNode) {
        try (HugeCursor<long[]> cursor = graphIds.initCursor(graphIds.newCursor(), startNode, endNode);){
            while (cursor.next()) {
                long[] array = (long[])cursor.array;
                int offset = cursor.offset;
                int limit = cursor.limit;
                long internalId = cursor.base + (long)offset;
                int i = offset;
                while (i < limit) {
                    builder.set(array[i], internalId);
                    ++i;
                    ++internalId;
                }
            }
        }
    }

    private ArrayIdMapBuilderOps() {
    }
}

