/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.ArrayIdMapBuilderOps;
import org.neo4j.gds.core.loading.IdMapAllocator;
import org.neo4j.gds.core.loading.IdMapBuilder;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.utils.CloseableThreadLocal;

public final class ArrayIdMapBuilder
implements IdMapBuilder {
    private final HugeLongArray array;
    private final long capacity;
    private final AtomicLong allocationIndex;
    private final CloseableThreadLocal<BulkAdder> adders;

    public static ArrayIdMapBuilder of(long capacity) {
        HugeLongArray array = HugeLongArray.newArray(capacity);
        return new ArrayIdMapBuilder(array, capacity);
    }

    private ArrayIdMapBuilder(HugeLongArray array, long capacity) {
        this.array = array;
        this.capacity = capacity;
        this.allocationIndex = new AtomicLong();
        this.adders = CloseableThreadLocal.withInitial(this::newBulkAdder);
    }

    @Override
    public BulkAdder allocate(int batchLength) {
        long startIndex = this.allocationIndex.getAndAccumulate(batchLength, this::upperAllocation);
        BulkAdder adder = this.adders.get();
        adder.reset(startIndex, this.upperAllocation(startIndex, batchLength));
        return adder;
    }

    private BulkAdder newBulkAdder() {
        return new BulkAdder(this.array, this.array.newCursor());
    }

    private long upperAllocation(long lower, long nodes) {
        return Math.min(this.capacity, lower + nodes);
    }

    @Override
    public IdMap build(LabelInformation.Builder labelInformationBuilder, long highestNodeId, int concurrency) {
        this.adders.close();
        long nodeCount = this.size();
        HugeLongArray graphIds = this.array();
        return ArrayIdMapBuilderOps.build(graphIds, nodeCount, labelInformationBuilder, highestNodeId, concurrency);
    }

    public HugeLongArray array() {
        return this.array;
    }

    public long size() {
        return this.allocationIndex.get();
    }

    public static final class BulkAdder
    implements IdMapAllocator {
        private long[] buffer;
        private int allocationSize;
        private long start;
        private int offset;
        private int length;
        private final HugeLongArray array;
        private final HugeCursor<long[]> cursor;

        private BulkAdder(HugeLongArray array, HugeCursor<long[]> cursor) {
            this.array = array;
            this.cursor = cursor;
        }

        private void reset(long start, long end) {
            this.array.initCursor(this.cursor, start, end);
            this.buffer = null;
            this.allocationSize = (int)(end - start);
            this.start = start;
            this.offset = 0;
            this.length = 0;
        }

        public boolean nextBuffer() {
            if (!this.cursor.next()) {
                return false;
            }
            this.start += (long)this.length;
            this.buffer = (long[])this.cursor.array;
            this.offset = this.cursor.offset;
            this.length = this.cursor.limit - this.cursor.offset;
            return true;
        }

        @Override
        public long startId() {
            return this.start;
        }

        @Override
        public int allocatedSize() {
            return this.allocationSize;
        }

        @Override
        public void insert(long[] nodeIds) {
            int batchOffset = 0;
            while (this.nextBuffer()) {
                System.arraycopy(nodeIds, batchOffset, this.buffer, this.offset, this.length);
                batchOffset += this.length;
            }
        }
    }
}

