/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.FilteredIdMap;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.LabeledIdMap;
import org.neo4j.gds.collections.HugeSparseCollections;
import org.neo4j.gds.collections.HugeSparseLongArray;
import org.neo4j.gds.core.loading.ArrayIdMapBuilderOps;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.mem.MemoryUsage;

public class ArrayIdMap
extends LabeledIdMap {
    private static final MemoryEstimation ESTIMATION = MemoryEstimations.builder(ArrayIdMap.class).perNode("Neo4j identifiers", HugeLongArray::memoryEstimation).rangePerGraphDimension("Mapping from Neo4j identifiers to internal identifiers", (dimensions, concurrency) -> HugeSparseCollections.estimateLong((long)dimensions.highestPossibleNodeCount(), (long)dimensions.nodeCount())).perGraphDimension("Node Label BitSets", (dimensions, concurrency) -> MemoryRange.of((long)((long)dimensions.estimationNodeLabelCount() * MemoryUsage.sizeOfBitset((long)dimensions.nodeCount())))).build();
    private final long highestNeoId;
    private final HugeLongArray graphIds;
    private final HugeSparseLongArray nodeToGraphIds;

    public static MemoryEstimation memoryEstimation() {
        return ESTIMATION;
    }

    public ArrayIdMap(HugeLongArray graphIds, HugeSparseLongArray nodeToGraphIds, LabelInformation labelInformation, long nodeCount, long highestNeoId) {
        super(labelInformation, nodeCount);
        this.graphIds = graphIds;
        this.nodeToGraphIds = nodeToGraphIds;
        this.highestNeoId = highestNeoId;
    }

    @Override
    public long toMappedNodeId(long originalNodeId) {
        return this.nodeToGraphIds.get(originalNodeId);
    }

    @Override
    public long toOriginalNodeId(long mappedNodeId) {
        return this.graphIds.get(mappedNodeId);
    }

    @Override
    public long toRootNodeId(long mappedNodeId) {
        return mappedNodeId;
    }

    @Override
    public IdMap rootIdMap() {
        return this;
    }

    @Override
    public boolean contains(long originalNodeId) {
        return this.nodeToGraphIds.contains(originalNodeId);
    }

    @Override
    public OptionalLong rootNodeCount() {
        return OptionalLong.of(this.nodeCount());
    }

    @Override
    public long highestNeoId() {
        return this.highestNeoId;
    }

    public Optional<FilteredArrayIdMap> withFilteredLabels(Collection<NodeLabel> nodeLabels, int concurrency) {
        this.labelInformation.validateNodeLabelFilter(nodeLabels);
        if (this.labelInformation.isEmpty()) {
            return Optional.empty();
        }
        BitSet unionBitSet = this.labelInformation.unionBitSet(nodeLabels, this.nodeCount());
        long nodeId = -1L;
        long cursor = 0L;
        long newNodeCount = unionBitSet.cardinality();
        HugeLongArray newGraphIds = HugeLongArray.newArray(newNodeCount);
        while ((nodeId = unionBitSet.nextSetBit(nodeId + 1L)) != -1L) {
            newGraphIds.set(cursor, nodeId);
            ++cursor;
        }
        HugeSparseLongArray newNodeToGraphIds = ArrayIdMapBuilderOps.buildSparseIdMap(newNodeCount, this.nodeToGraphIds.capacity(), concurrency, newGraphIds);
        LabelInformation newLabelInformation = this.labelInformation.filter(nodeLabels);
        return Optional.of(new FilteredArrayIdMap(this, newGraphIds, newNodeToGraphIds, newLabelInformation, newNodeCount, this.highestNeoId));
    }

    private static class FilteredArrayIdMap
    extends ArrayIdMap
    implements FilteredIdMap {
        private final IdMap rootIdMap;

        FilteredArrayIdMap(IdMap rootIdMap, HugeLongArray graphIds, HugeSparseLongArray nodeToGraphIds, LabelInformation filteredLabelInformation, long nodeCount, long highestNeoId) {
            super(graphIds, nodeToGraphIds, filteredLabelInformation, nodeCount, highestNeoId);
            this.rootIdMap = rootIdMap;
        }

        @Override
        public List<NodeLabel> nodeLabels(long mappedNodeId) {
            return super.nodeLabels(super.toOriginalNodeId(mappedNodeId));
        }

        @Override
        public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
            super.forEachNodeLabel(super.toOriginalNodeId(mappedNodeId), consumer);
        }

        @Override
        public OptionalLong rootNodeCount() {
            return this.rootIdMap.rootNodeCount();
        }

        @Override
        public long toRootNodeId(long mappedNodeId) {
            return super.toRootNodeId(super.toOriginalNodeId(mappedNodeId));
        }

        @Override
        public long rootToMappedNodeId(long rootNodeId) {
            return super.toMappedNodeId(rootNodeId);
        }

        @Override
        public long toOriginalNodeId(long mappedNodeId) {
            return this.rootIdMap.toOriginalNodeId(super.toOriginalNodeId(mappedNodeId));
        }

        @Override
        public long toMappedNodeId(long originalNodeId) {
            return super.toMappedNodeId(this.rootIdMap.toMappedNodeId(originalNodeId));
        }

        @Override
        public boolean contains(long originalNodeId) {
            return super.contains(this.rootIdMap.toMappedNodeId(originalNodeId));
        }

        @Override
        public boolean containsRootNodeId(long rootNodeId) {
            return super.contains(rootNodeId);
        }

        @Override
        public IdMap rootIdMap() {
            return this.rootIdMap.rootIdMap();
        }

        @Override
        public boolean hasLabel(long mappedNodeId, NodeLabel label) {
            return super.hasLabel(super.toOriginalNodeId(mappedNodeId), label);
        }
    }
}

