/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.AdjacencyCompression;
import org.neo4j.gds.core.loading.AdjacencyPacking;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public final class AdjacencyPacker {
    public static final int PASS = 0;
    public static final int SORT = 0x400000;
    public static final int DELTA = 0x800000;
    private static final int MASK = -12582913;

    private AdjacencyPacker() {
    }

    public static Compressed compress(long[] values, int offset, int length, int flags) {
        if ((flags & 0x400000) == 0x400000) {
            Arrays.sort(values, offset, offset + length);
        }
        if ((flags & 0x800000) == 0x800000) {
            int ordinal = flags & 0xFF3FFFFF;
            Aggregation aggregation = Aggregation.resolve((Aggregation)Aggregation.values()[ordinal]);
            length = AdjacencyCompression.deltaEncodeSortedValues(values, offset, length, aggregation);
        }
        return AdjacencyPacker.compress(values, offset, length);
    }

    public static Compressed compress(long[] values, int offset, int length) {
        long mem;
        int end = offset + length;
        int blocks = length / 64;
        byte[] allBits = new byte[blocks];
        long bytes = 0L;
        int i = offset;
        int blockIdx = 0;
        while (i + 64 <= end) {
            int bits = AdjacencyPacker.bitsNeeded(values, i, 64);
            bytes += (long)AdjacencyPacker.bytesNeeded(bits);
            allBits[blockIdx++] = (byte)bits;
            i += 64;
        }
        bytes = BitUtil.align((long)bytes, (int)8);
        long ptr = mem = UnsafeUtil.allocateMemory((long)bytes, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        i = offset;
        for (byte bits : allBits) {
            ptr = AdjacencyPacking.pack(bits, values, i, ptr);
            i += 64;
        }
        return new Compressed(mem, bytes, allBits);
    }

    public static long[] decompressAndPrefixSum(Compressed compressed) {
        long[] values = new long[compressed.bits.length * 64];
        long value = values[0];
        int offset = 0;
        long ptr = compressed.address;
        for (byte bits : compressed.bits) {
            ptr = AdjacencyPacking.unpack(bits, values, offset, ptr);
            for (int i = 0; i < 64; ++i) {
                int n = offset + i;
                long l = values[n] + value;
                values[n] = l;
                value = l;
            }
            offset += 64;
        }
        return values;
    }

    public static long[] decompress(Compressed compressed) {
        long[] values = new long[compressed.bits.length * 64];
        int offset = 0;
        long ptr = compressed.address;
        for (byte bits : compressed.bits) {
            ptr = AdjacencyPacking.unpack(bits, values, offset, ptr);
            offset += 64;
        }
        return values;
    }

    private static int bitsNeeded(long[] values, int offset, int length) {
        long bits = 0L;
        for (int i = offset; i < offset + length; ++i) {
            bits |= values[i];
        }
        return 64 - Long.numberOfLeadingZeros(bits);
    }

    private static int bytesNeeded(int bits) {
        return BitUtil.ceilDiv((int)(64 * bits), (int)8);
    }

    public static final class Compressed {
        private final long address;
        private final long bytes;
        private final byte[] bits;

        public Compressed(long address, long bytes, byte[] bits) {
            this.address = address;
            this.bytes = bytes;
            this.bits = bits;
        }

        public long bytesUsed() {
            return this.bytes + (long)this.bits.length;
        }

        public void free() {
            UnsafeUtil.free((long)this.address, (long)this.bytes, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        public String toString() {
            return "Compressed{address=" + this.address + ", bytes=" + this.bytes + ", blocks=" + this.bits.length + "}";
        }
    }
}

