/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.core.utils.PageReordering;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.utils.GdsFeatureToggles;

public interface AdjacencyListBuilder<PAGE, T> {
    public Allocator<PAGE> newAllocator();

    public Allocator<PAGE> newPositionalAllocator();

    public T build(HugeIntArray var1, HugeLongArray var2);

    default public void reorder(PAGE[] pages, HugeLongArray offsets, HugeIntArray degrees) {
        if (GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.isEnabled() && pages.length > 0) {
            PageReordering.reorder(pages, offsets, degrees);
        }
    }

    public static interface Allocator<PAGE>
    extends AutoCloseable {
        public long write(PAGE var1, int var2, long var3);

        @Override
        public void close();
    }
}

