/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import java.util.Arrays;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.LongArrayBuffer;
import org.neo4j.gds.core.huge.VarLongDecoding;
import org.neo4j.gds.core.loading.VarLongEncoding;
import org.neo4j.gds.core.loading.ZigZagLongDecoding;
import org.neo4j.gds.core.utils.AscendingLongComparator;

public final class AdjacencyCompression {
    public static void copyFrom(LongArrayBuffer into, byte[] targets, int compressedValues, int limit, AdjacencyCompressor.ValueMapper mapper) {
        into.ensureCapacity(compressedValues);
        AdjacencyCompression.copyFrom(into.buffer, targets, compressedValues, limit, mapper);
        into.length = compressedValues;
    }

    public static void copyFrom(long[] into, byte[] targets, int compressedValues, int limit, AdjacencyCompressor.ValueMapper mapper) {
        assert (into.length >= compressedValues);
        ZigZagLongDecoding.zigZagUncompress(targets, limit, into, mapper);
    }

    public static int applyDeltaEncoding(LongArrayBuffer data, Aggregation aggregation) {
        data.length = AdjacencyCompression.applyDeltaEncoding(data.buffer, data.length, aggregation);
        return data.length;
    }

    public static int applyDeltaEncoding(long[] data, int length, Aggregation aggregation) {
        Arrays.sort(data, 0, length);
        return AdjacencyCompression.deltaEncodeSortedValues(data, 0, length, aggregation);
    }

    static int applyDeltaEncoding(LongArrayBuffer data, long[][] weights, Aggregation[] aggregations, boolean noAggregation) {
        data.length = AdjacencyCompression.applyDeltaEncoding(data.buffer, data.length, weights, aggregations, noAggregation);
        return data.length;
    }

    static int applyDeltaEncoding(long[] data, int length, long[][] weights, Aggregation[] aggregations, boolean noAggregation) {
        int[] order = IndirectSort.mergesort((int)0, (int)length, (IndirectComparator)new AscendingLongComparator(data));
        long[] sortedValues = new long[length];
        long[][] sortedWeights = new long[weights.length][length];
        length = AdjacencyCompression.applyDelta(order, data, sortedValues, weights, sortedWeights, length, aggregations, noAggregation);
        System.arraycopy(sortedValues, 0, data, 0, length);
        for (int i = 0; i < sortedWeights.length; ++i) {
            long[] sortedWeight = sortedWeights[i];
            System.arraycopy(sortedWeight, 0, weights[i], 0, length);
        }
        return length;
    }

    static byte[] ensureBufferSize(LongArrayBuffer data, byte[] out) {
        return AdjacencyCompression.ensureBufferSize(data.buffer, out, data.length);
    }

    static byte[] ensureBufferSize(long[] data, byte[] out, int length) {
        int requiredBytes = VarLongEncoding.encodedVLongsSize(data, length);
        if (requiredBytes > out.length) {
            return new byte[requiredBytes];
        }
        return out;
    }

    public static int compress(LongArrayBuffer data, byte[] out) {
        return AdjacencyCompression.compress(data.buffer, out, data.length);
    }

    public static int compress(long[] data, byte[] out, int length) {
        return VarLongEncoding.encodeVLongs(data, length, out, 0);
    }

    public static int compress(long[] data, int offset, int length, byte[] out) {
        return VarLongEncoding.encodeVLongs(data, offset, offset + length, out, 0);
    }

    public static byte[] deltaEncodeAndCompress(long[] values, int offset, int length, Aggregation aggregation) {
        length = AdjacencyCompression.deltaEncodeSortedValues(values, offset, length, aggregation);
        int requiredBytes = VarLongEncoding.encodedVLongsSize(values, offset, length);
        byte[] compressed = new byte[requiredBytes];
        AdjacencyCompression.compress(values, offset, length, compressed);
        return compressed;
    }

    public static long[] decompress(byte[] compressed, int numberOfValues) {
        long[] out = new long[numberOfValues];
        VarLongDecoding.decodeDeltaVLongs(0L, compressed, 0, numberOfValues, out);
        return out;
    }

    public static int deltaEncodeSortedValues(long[] values, int offset, int length, Aggregation aggregation) {
        int in;
        long value = values[offset];
        int end = offset + length;
        int out = in = offset + 1;
        while (in < end) {
            long delta = values[in] - value;
            value = values[in];
            if (delta > 0L || aggregation == Aggregation.NONE) {
                values[out++] = delta;
            }
            ++in;
        }
        return out;
    }

    public static void prefixSumDeltaEncodedValues(long[] values, int length) {
        length = Math.min(values.length, length);
        long value = values[0];
        int idx = 1;
        while (idx < length) {
            int n = idx++;
            long l = values[n] + value;
            values[n] = l;
            value = l;
        }
    }

    private static int applyDelta(int[] order, long[] values, long[] outValues, long[][] weights, long[][] outWeights, int length, Aggregation[] aggregations, boolean noAggregation) {
        int firstSortIdx = order[0];
        long value = values[firstSortIdx];
        outValues[0] = values[firstSortIdx];
        for (int i = 0; i < weights.length; ++i) {
            outWeights[i][0] = weights[i][firstSortIdx];
        }
        int out = 1;
        for (int in = 1; in < length; ++in) {
            int i;
            int sortIdx = order[in];
            long delta = values[sortIdx] - value;
            value = values[sortIdx];
            if (delta > 0L || noAggregation) {
                for (i = 0; i < weights.length; ++i) {
                    outWeights[i][out] = weights[i][sortIdx];
                }
                outValues[out++] = delta;
                continue;
            }
            for (i = 0; i < weights.length; ++i) {
                Aggregation aggregation = aggregations[i];
                int existingIdx = out - 1;
                long[] outWeight = outWeights[i];
                double existingWeight = Double.longBitsToDouble(outWeight[existingIdx]);
                double newWeight = Double.longBitsToDouble(weights[i][sortIdx]);
                newWeight = aggregation.merge(existingWeight, newWeight);
                outWeight[existingIdx] = Double.doubleToLongBits(newWeight);
            }
        }
        return out;
    }

    private AdjacencyCompression() {
    }
}

