/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;

@ParametersAreNonnullByDefault
@Generated(from="AdjacencyBuffer.of", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class AdjacencyBufferBuilder {
    private static final long INIT_BIT_IMPORT_META_DATA = 1L;
    private static final long INIT_BIT_ADJACENCY_COMPRESSOR_FACTORY = 2L;
    private static final long INIT_BIT_IMPORT_SIZING = 4L;
    private long initBits = 7L;
    @Nullable
    private SingleTypeRelationshipImporter.ImportMetaData importMetaData;
    @Nullable
    private AdjacencyCompressorFactory adjacencyCompressorFactory;
    @Nullable
    private ImportSizing importSizing;

    public final AdjacencyBufferBuilder importMetaData(SingleTypeRelationshipImporter.ImportMetaData importMetaData) {
        this.importMetaData = Objects.requireNonNull(importMetaData, "importMetaData");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final AdjacencyBufferBuilder adjacencyCompressorFactory(AdjacencyCompressorFactory adjacencyCompressorFactory) {
        this.adjacencyCompressorFactory = Objects.requireNonNull(adjacencyCompressorFactory, "adjacencyCompressorFactory");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final AdjacencyBufferBuilder importSizing(ImportSizing importSizing) {
        this.importSizing = Objects.requireNonNull(importSizing, "importSizing");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public AdjacencyBuffer build() {
        this.checkRequiredAttributes();
        return AdjacencyBuffer.of(this.importMetaData, this.adjacencyCompressorFactory, this.importSizing);
    }

    private boolean importMetaDataIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean adjacencyCompressorFactoryIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean importSizingIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.importMetaDataIsSet()) {
            attributes.add("importMetaData");
        }
        if (!this.adjacencyCompressorFactoryIsSet()) {
            attributes.add("adjacencyCompressorFactory");
        }
        if (!this.importSizingIsSet()) {
            attributes.add("importSizing");
        }
        return "Cannot build of, some of required attributes are not set " + attributes;
    }
}

