/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableLong;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.compress.LongArrayBuffer;
import org.neo4j.gds.core.loading.AdjacencyBufferPaging;
import org.neo4j.gds.core.loading.ChunkedAdjacencyLists;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.ThreadLocalRelationshipsBuilder;
import org.neo4j.gds.core.loading.ThreadLocalRelationshipsCompressor;
import org.neo4j.gds.core.loading.ZigZagLongDecoding;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.mem.MemoryUsage;

@Value.Style(typeBuilder="AdjacencyBufferBuilder")
public final class AdjacencyBuffer {
    private final AdjacencyCompressorFactory adjacencyCompressorFactory;
    private final ThreadLocalRelationshipsBuilder[] localBuilders;
    private final ChunkedAdjacencyLists[] chunkedAdjacencyLists;
    private final AdjacencyBufferPaging paging;
    private final LongAdder relationshipCounter;
    private final int[] propertyKeyIds;
    private final double[] defaultValues;
    private final Aggregation[] aggregations;
    private final boolean atLeastOnePropertyToLoad;

    public static MemoryEstimation memoryEstimation(RelationshipType relationshipType, int propertyCount, boolean undirected) {
        return MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            long nodeCount = dimensions.nodeCount();
            long relCountForType = dimensions.relationshipCounts().getOrDefault(relationshipType, dimensions.relCountUpperBound());
            long relCount = undirected ? relCountForType * 2L : relCountForType;
            long avgDegree = nodeCount > 0L ? BitUtil.ceilDiv((long)relCount, (long)nodeCount) : 0L;
            return AdjacencyBuffer.memoryEstimation(avgDegree, nodeCount, propertyCount, concurrency);
        });
    }

    public static MemoryEstimation memoryEstimation(long avgDegree, long nodeCount, int propertyCount, int concurrency) {
        ImportSizing importSizing = ImportSizing.of(concurrency, nodeCount);
        int numberOfPages = importSizing.numberOfPages();
        int pageSize = importSizing.pageSize().getAsInt();
        return MemoryEstimations.builder(AdjacencyBuffer.class).fixed("ChunkedAdjacencyLists pages", MemoryUsage.sizeOfObjectArray((long)numberOfPages)).add("ChunkedAdjacencyLists", ChunkedAdjacencyLists.memoryEstimation(avgDegree, pageSize, propertyCount).times((long)numberOfPages)).build();
    }

    @Builder.Factory
    public static AdjacencyBuffer of(SingleTypeRelationshipImporter.ImportMetaData importMetaData, AdjacencyCompressorFactory adjacencyCompressorFactory, ImportSizing importSizing) {
        int numPages = importSizing.numberOfPages();
        OptionalInt pageSize = importSizing.pageSize();
        ThreadLocalRelationshipsBuilder[] localBuilders = new ThreadLocalRelationshipsBuilder[numPages];
        ChunkedAdjacencyLists[] compressedAdjacencyLists = new ChunkedAdjacencyLists[numPages];
        for (int page = 0; page < numPages; ++page) {
            compressedAdjacencyLists[page] = ChunkedAdjacencyLists.of(importMetaData.propertyKeyIds().length, pageSize.orElse(0));
            localBuilders[page] = new ThreadLocalRelationshipsBuilder(adjacencyCompressorFactory);
        }
        boolean atLeastOnePropertyToLoad = Arrays.stream(importMetaData.propertyKeyIds()).anyMatch(keyId -> keyId != -1);
        AdjacencyBufferPaging paging = pageSize.isPresent() ? new PagingWithKnownPageSize(pageSize.getAsInt()) : new PagingWithUnknownPageSize(numPages);
        return new AdjacencyBuffer(importMetaData, adjacencyCompressorFactory, localBuilders, compressedAdjacencyLists, paging, atLeastOnePropertyToLoad);
    }

    private AdjacencyBuffer(SingleTypeRelationshipImporter.ImportMetaData importMetaData, AdjacencyCompressorFactory adjacencyCompressorFactory, ThreadLocalRelationshipsBuilder[] localBuilders, ChunkedAdjacencyLists[] chunkedAdjacencyLists, AdjacencyBufferPaging paging, boolean atLeastOnePropertyToLoad) {
        this.adjacencyCompressorFactory = adjacencyCompressorFactory;
        this.localBuilders = localBuilders;
        this.chunkedAdjacencyLists = chunkedAdjacencyLists;
        this.paging = paging;
        this.relationshipCounter = adjacencyCompressorFactory.relationshipCounter();
        this.propertyKeyIds = importMetaData.propertyKeyIds();
        this.defaultValues = importMetaData.defaultValues();
        this.aggregations = importMetaData.aggregations();
        this.atLeastOnePropertyToLoad = atLeastOnePropertyToLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAll(long[] batch, long[] targets, @Nullable long[][] propertyValues, int[] offsets, int length) {
        AdjacencyBufferPaging paging = this.paging;
        ThreadLocalRelationshipsBuilder builder = null;
        int lastPageIndex = -1;
        int startOffset = 0;
        try {
            for (int i = 0; i < length; ++i) {
                int endOffset = offsets[i];
                if (endOffset <= startOffset) continue;
                long source = batch[startOffset << 1];
                int pageIndex = paging.pageId(source);
                if (pageIndex != lastPageIndex) {
                    if (builder != null) {
                        builder.unlock();
                    }
                    builder = this.localBuilders[pageIndex];
                    builder.lock();
                    lastPageIndex = pageIndex;
                }
                long localId = paging.localId(source);
                ChunkedAdjacencyLists compressedTargets = this.chunkedAdjacencyLists[pageIndex];
                int targetsToImport = endOffset - startOffset;
                if (propertyValues == null) {
                    compressedTargets.add(localId, targets, startOffset, endOffset, targetsToImport);
                } else {
                    compressedTargets.add(localId, targets, propertyValues, startOffset, endOffset, targetsToImport);
                }
                startOffset = endOffset;
            }
        }
        finally {
            if (builder != null && builder.isLockedByCurrentThread()) {
                builder.unlock();
            }
        }
    }

    Collection<AdjacencyListBuilderTask> adjacencyListBuilderTasks(Optional<AdjacencyCompressor.ValueMapper> mapper, Optional<LongConsumer> drainCountConsumer) {
        this.adjacencyCompressorFactory.init();
        ArrayList<AdjacencyListBuilderTask> tasks = new ArrayList<AdjacencyListBuilderTask>(this.localBuilders.length + 1);
        for (int page = 0; page < this.localBuilders.length; ++page) {
            tasks.add(new AdjacencyListBuilderTask(page, this.paging, this.localBuilders[page], this.chunkedAdjacencyLists[page], this.relationshipCounter, mapper.orElse(ZigZagLongDecoding.Identity.INSTANCE), drainCountConsumer.orElse(n -> {})));
        }
        return tasks;
    }

    int[] getPropertyKeyIds() {
        return this.propertyKeyIds;
    }

    double[] getDefaultValues() {
        return this.defaultValues;
    }

    Aggregation[] getAggregations() {
        return this.aggregations;
    }

    boolean atLeastOnePropertyToLoad() {
        return this.atLeastOnePropertyToLoad;
    }

    private static final class PagingWithUnknownPageSize
    implements AdjacencyBufferPaging {
        private final int pageShift;
        private final int pageMask;

        PagingWithUnknownPageSize(int numberOfPages) {
            this.pageShift = Integer.numberOfTrailingZeros(numberOfPages);
            this.pageMask = numberOfPages - 1;
        }

        @Override
        public int pageId(long source) {
            return (int)(source & (long)this.pageMask);
        }

        @Override
        public long localId(long source) {
            return source >>> this.pageShift;
        }

        @Override
        public long sourceNodeId(long localId, int pageId) {
            return (localId << this.pageShift) + (long)pageId;
        }
    }

    private static final class PagingWithKnownPageSize
    implements AdjacencyBufferPaging {
        private final int pageShift;
        private final int pageMask;

        PagingWithKnownPageSize(int pageSize) {
            this.pageShift = Integer.numberOfTrailingZeros(pageSize);
            this.pageMask = pageSize - 1;
        }

        @Override
        public int pageId(long source) {
            return (int)(source >>> this.pageShift);
        }

        @Override
        public long localId(long source) {
            return source & (long)this.pageMask;
        }

        @Override
        public long sourceNodeId(long localId, int pageId) {
            return ((long)pageId << this.pageShift) + localId;
        }
    }

    static final class AdjacencyListBuilderTask
    implements Runnable {
        private final int page;
        private final AdjacencyBufferPaging paging;
        private final ThreadLocalRelationshipsBuilder threadLocalRelationshipsBuilder;
        private final ChunkedAdjacencyLists chunkedAdjacencyLists;
        private final LongArrayBuffer buffer;
        private final LongAdder relationshipCounter;
        private final AdjacencyCompressor.ValueMapper valueMapper;
        private final LongConsumer drainCountConsumer;

        AdjacencyListBuilderTask(int page, AdjacencyBufferPaging paging, ThreadLocalRelationshipsBuilder threadLocalRelationshipsBuilder, ChunkedAdjacencyLists chunkedAdjacencyLists, LongAdder relationshipCounter, AdjacencyCompressor.ValueMapper valueMapper, LongConsumer drainCountConsumer) {
            this.page = page;
            this.paging = paging;
            this.threadLocalRelationshipsBuilder = threadLocalRelationshipsBuilder;
            this.chunkedAdjacencyLists = chunkedAdjacencyLists;
            this.valueMapper = valueMapper;
            this.drainCountConsumer = drainCountConsumer;
            this.buffer = new LongArrayBuffer();
            this.relationshipCounter = relationshipCounter;
        }

        @Override
        public void run() {
            try (ThreadLocalRelationshipsCompressor compressor = this.threadLocalRelationshipsBuilder.intoCompressor();){
                MutableLong importedRelationships = new MutableLong(0L);
                this.chunkedAdjacencyLists.consume((localId, targets, properties, compressedByteSize, numberOfCompressedTargets) -> {
                    long sourceNodeId = this.paging.sourceNodeId(localId, this.page);
                    long nodeId = this.valueMapper.map(sourceNodeId);
                    importedRelationships.add((long)compressor.applyVariableDeltaEncoding(nodeId, targets, properties, numberOfCompressedTargets, compressedByteSize, this.buffer, this.valueMapper));
                });
                this.relationshipCounter.add(importedRelationships.longValue());
                this.drainCountConsumer.accept(importedRelationships.longValue());
            }
        }
    }
}

