/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.compat.StoreScan;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.kernel.api.KernelTransaction;

abstract class AbstractCursorBasedScanner<Reference, EntityCursor extends Cursor>
implements StoreScanner<Reference> {
    private final int prefetchSize;
    private final TransactionContext.SecureTransaction transaction;
    private volatile StoreScan<EntityCursor> entityCursorScan;

    AbstractCursorBasedScanner(int prefetchSize, TransactionContext transactionContext) {
        this.transaction = transactionContext.fork();
        this.prefetchSize = prefetchSize;
    }

    @Override
    public void close() {
        this.transaction.close();
    }

    @Override
    public final StoreScanner.ScanCursor<Reference> createCursor(KernelTransaction transaction) {
        StoreScan<EntityCursor> entityCursorScan = this.createEntityCursorScan();
        EntityCursor entityCursor = this.entityCursor(transaction);
        Reference reference = this.cursorReference(transaction, entityCursor);
        return new ScanCursor(this, entityCursor, reference, entityCursorScan, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreScan<EntityCursor> createEntityCursorScan() {
        StoreScan<EntityCursor> scan = this.entityCursorScan;
        if (scan != null) {
            return scan;
        }
        AbstractCursorBasedScanner abstractCursorBasedScanner = this;
        synchronized (abstractCursorBasedScanner) {
            scan = this.entityCursorScan;
            if (scan != null) {
                return scan;
            }
            this.entityCursorScan = scan = this.entityCursorScan(this.transaction.kernelTransaction());
            return scan;
        }
    }

    abstract int recordsPerPage();

    abstract EntityCursor entityCursor(KernelTransaction var1);

    abstract StoreScan<EntityCursor> entityCursorScan(KernelTransaction var1);

    abstract Reference cursorReference(KernelTransaction var1, EntityCursor var2);

    abstract void closeCursorReference(Reference var1);

    int batchSize() {
        int bulkSize = this.prefetchSize * this.recordsPerPage();
        bulkSize = (int)BitUtil.align((long)bulkSize, (int)64);
        return bulkSize;
    }

    @Override
    public int bufferSize() {
        return this.batchSize();
    }

    private static final class ScanCursor
    implements StoreScanner.ScanCursor<Reference> {
        private EntityCursor cursor;
        private Reference cursorReference;
        private final StoreScan<EntityCursor> scan;
        private final KernelTransaction ktx;
        final /* synthetic */ AbstractCursorBasedScanner this$0;

        ScanCursor(EntityCursor cursor, Reference reference, StoreScan<EntityCursor> entityCursorScan, KernelTransaction ktx) {
            this.this$0 = var1_1;
            this.cursor = cursor;
            this.cursorReference = reference;
            this.scan = entityCursorScan;
            this.ktx = ktx;
        }

        @Override
        public boolean bulkNext(StoreScanner.RecordConsumer<Reference> consumer) {
            boolean hasNextBatch = this.scan.scanBatch(this.cursor, this.ktx);
            if (!hasNextBatch) {
                return false;
            }
            while (this.cursor.next()) {
                consumer.offer(this.cursorReference);
            }
            return true;
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                this.this$0.closeCursorReference(this.cursorReference);
                this.cursorReference = null;
                this.cursor.close();
                this.cursor = null;
            }
        }
    }
}

