/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongSupplier;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.compress.AdjacencyListsWithProperties;
import org.neo4j.gds.core.compress.ImmutableAdjacencyListsWithProperties;
import org.neo4j.gds.core.loading.AdjacencyListBuilder;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

abstract class AbstractAdjacencyCompressorFactory<TARGET_PAGE, PROPERTY_PAGE>
implements AdjacencyCompressorFactory {
    final LongSupplier nodeCountSupplier;
    final AdjacencyListBuilder<TARGET_PAGE, ? extends AdjacencyList> adjacencyBuilder;
    final AdjacencyListBuilder<PROPERTY_PAGE, ? extends AdjacencyProperties>[] propertyBuilders;
    final boolean noAggregation;
    final Aggregation[] aggregations;
    final LongAdder relationshipCounter;
    HugeIntArray adjacencyDegrees;
    HugeLongArray adjacencyOffsets;
    HugeLongArray propertyOffsets;

    AbstractAdjacencyCompressorFactory(LongSupplier nodeCountSupplier, AdjacencyListBuilder<TARGET_PAGE, ? extends AdjacencyList> adjacencyBuilder, AdjacencyListBuilder<PROPERTY_PAGE, ? extends AdjacencyProperties>[] propertyBuilders, boolean noAggregation, Aggregation[] aggregations) {
        this.adjacencyBuilder = adjacencyBuilder;
        this.propertyBuilders = propertyBuilders;
        this.nodeCountSupplier = nodeCountSupplier;
        this.noAggregation = noAggregation;
        this.aggregations = aggregations;
        this.relationshipCounter = new LongAdder();
    }

    @Override
    public void init() {
        long nodeCount = this.nodeCountSupplier.getAsLong();
        this.adjacencyDegrees = HugeIntArray.newArray(nodeCount);
        this.adjacencyOffsets = HugeLongArray.newArray(nodeCount);
        this.propertyOffsets = HugeLongArray.newArray(nodeCount);
    }

    @Override
    public LongAdder relationshipCounter() {
        return this.relationshipCounter;
    }

    @Override
    public AdjacencyListsWithProperties build() {
        ImmutableAdjacencyListsWithProperties.Builder builder = ImmutableAdjacencyListsWithProperties.builder().adjacency(this.adjacencyBuilder.build(this.adjacencyDegrees, this.adjacencyOffsets));
        AdjacencyListBuilder<PROPERTY_PAGE, ? extends AdjacencyProperties>[] propertyBuilders = this.propertyBuilders;
        HugeLongArray propertyOffsets = this.propertyOffsets;
        for (AdjacencyListBuilder<PROPERTY_PAGE, AdjacencyProperties> adjacencyListBuilder : propertyBuilders) {
            AdjacencyProperties properties = adjacencyListBuilder.build(this.adjacencyDegrees, propertyOffsets);
            builder.addProperty(properties);
        }
        return builder.relationshipCount(this.relationshipCounter.longValue()).build();
    }
}

