/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import com.carrotsearch.hppc.BitSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipCursor;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.huge.CompositeAdjacencyList;
import org.neo4j.gds.core.huge.NodeFilteredGraph;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;

public final class UnionGraph
implements CSRGraph {
    private final CSRGraph first;
    private final List<? extends CSRGraph> graphs;
    private final Map<RelationshipType, Relationships.Topology> relationshipTypeTopologies;

    public static CSRGraph of(List<? extends CSRGraph> graphs) {
        if (graphs.isEmpty()) {
            throw new IllegalArgumentException("no graphs");
        }
        if (graphs.size() == 1) {
            return graphs.get(0);
        }
        return new UnionGraph(graphs);
    }

    private UnionGraph(List<? extends CSRGraph> graphs) {
        this.first = graphs.get(0);
        this.graphs = graphs;
        this.relationshipTypeTopologies = new HashMap<RelationshipType, Relationships.Topology>();
        graphs.forEach(graph -> this.relationshipTypeTopologies.putAll(graph.relationshipTopologies()));
    }

    @Override
    public long nodeCount() {
        return this.first.nodeCount();
    }

    @Override
    public OptionalLong rootNodeCount() {
        return this.first.rootNodeCount();
    }

    @Override
    public long highestNeoId() {
        return this.first.highestNeoId();
    }

    @Override
    public GraphSchema schema() {
        return this.graphs.stream().map(Graph::schema).reduce(GraphSchema::union).orElseThrow(() -> new IllegalArgumentException("no graphs"));
    }

    @Override
    public long relationshipCount() {
        return this.graphs.stream().mapToLong(Graph::relationshipCount).sum();
    }

    @Override
    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return this.first.batchIterables(batchSize);
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        this.first.forEachNode(consumer);
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator() {
        return this.first.nodeIterator();
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Set<NodeLabel> labels) {
        return this.first.nodeIterator(labels);
    }

    @Override
    public NodePropertyValues nodeProperties(String propertyKey) {
        return this.first.nodeProperties(propertyKey);
    }

    @Override
    public Set<String> availableNodeProperties() {
        return this.first.availableNodeProperties();
    }

    @Override
    public long toMappedNodeId(long originalNodeId) {
        return this.first.toMappedNodeId(originalNodeId);
    }

    @Override
    public long toOriginalNodeId(long mappedNodeId) {
        return this.first.toOriginalNodeId(mappedNodeId);
    }

    @Override
    public long toRootNodeId(long mappedNodeId) {
        return this.first.toRootNodeId(mappedNodeId);
    }

    @Override
    public IdMap rootIdMap() {
        return this.first.rootIdMap();
    }

    @Override
    public boolean contains(long originalNodeId) {
        return this.first.contains(originalNodeId);
    }

    @Override
    public double relationshipProperty(long sourceNodeId, long targetNodeId, double fallbackValue) {
        for (Graph graph : this.graphs) {
            double property = graph.relationshipProperty(sourceNodeId, targetNodeId, fallbackValue);
            if (Double.isNaN(property) || property == fallbackValue) continue;
            return property;
        }
        return fallbackValue;
    }

    @Override
    public double relationshipProperty(long sourceNodeId, long targetNodeId) {
        for (Graph graph : this.graphs) {
            double property = graph.relationshipProperty(sourceNodeId, targetNodeId);
            if (Double.isNaN(property)) continue;
            return property;
        }
        return Double.NaN;
    }

    @Override
    public Map<RelationshipType, Relationships.Topology> relationshipTopologies() {
        return this.relationshipTypeTopologies;
    }

    @Override
    public void forEachRelationship(long nodeId, RelationshipConsumer consumer) {
        for (Graph graph : this.graphs) {
            graph.forEachRelationship(nodeId, consumer);
        }
    }

    @Override
    public void forEachRelationship(long nodeId, double fallbackValue, RelationshipWithPropertyConsumer consumer) {
        for (Graph graph : this.graphs) {
            graph.forEachRelationship(nodeId, fallbackValue, consumer);
        }
    }

    @Override
    public Stream<RelationshipCursor> streamRelationships(long nodeId, double fallbackValue) {
        return this.graphs.stream().flatMap(graph -> graph.streamRelationships(nodeId, fallbackValue));
    }

    @Override
    public Graph relationshipTypeFilteredGraph(Set<RelationshipType> relationshipTypes) {
        ArrayList<CSRGraph> filteredGraphs = new ArrayList<CSRGraph>();
        for (CSRGraph cSRGraph : this.graphs) {
            if (!relationshipTypes.isEmpty() && !relationshipTypes.containsAll(cSRGraph.schema().relationshipSchema().availableTypes())) continue;
            filteredGraphs.add(cSRGraph);
        }
        return UnionGraph.of(filteredGraphs);
    }

    @Override
    public int degree(long nodeId) {
        long degree = 0L;
        for (CSRGraph cSRGraph : this.graphs) {
            degree += (long)cSRGraph.degree(nodeId);
        }
        return Math.toIntExact(degree);
    }

    @Override
    public int degreeWithoutParallelRelationships(long nodeId) {
        if (!this.isMultiGraph()) {
            return this.degree(nodeId);
        }
        ParallelRelationshipDegreeCounter degreeCounter = new ParallelRelationshipDegreeCounter();
        this.graphs.forEach(graph -> graph.forEachRelationship(nodeId, degreeCounter));
        return degreeCounter.degree();
    }

    @Override
    public CSRGraph concurrentCopy() {
        return UnionGraph.of(this.graphs.stream().map(CSRGraph::concurrentCopy).collect(Collectors.toList()));
    }

    @Override
    public Optional<NodeFilteredGraph> asNodeFilteredGraph() {
        return this.first.asNodeFilteredGraph();
    }

    @Override
    public boolean exists(long sourceNodeId, long targetNodeId) {
        return this.graphs.stream().anyMatch(g -> g.exists(sourceNodeId, targetNodeId));
    }

    @Override
    public long nthTarget(long nodeId, int offset) {
        int remaining = offset;
        for (CSRGraph cSRGraph : this.graphs) {
            int localDegree = cSRGraph.degree(nodeId);
            if (localDegree > remaining) {
                return cSRGraph.nthTarget(nodeId, remaining);
            }
            remaining -= localDegree;
        }
        return -1L;
    }

    @Override
    public void canRelease(boolean canRelease) {
        for (Graph graph : this.graphs) {
            graph.canRelease(canRelease);
        }
    }

    @Override
    public void releaseTopology() {
        for (Graph graph : this.graphs) {
            graph.releaseTopology();
        }
    }

    @Override
    public void releaseProperties() {
        for (Graph graph : this.graphs) {
            graph.releaseProperties();
        }
    }

    @Override
    public boolean hasRelationshipProperty() {
        return this.first.hasRelationshipProperty();
    }

    @Override
    public boolean isMultiGraph() {
        return true;
    }

    public CompositeAdjacencyList relationshipTopology() {
        List<AdjacencyList> adjacencies = this.graphs.stream().map(CSRGraph::relationshipTopologies).map(Map::values).flatMap(Collection::stream).map(Relationships.Topology::adjacencyList).collect(Collectors.toList());
        if (this.isNodeFilteredGraph()) {
            return CompositeAdjacencyList.withFilteredIdMap(adjacencies, this.first);
        }
        return CompositeAdjacencyList.of(adjacencies);
    }

    @Override
    public List<NodeLabel> nodeLabels(long mappedNodeId) {
        return this.first.nodeLabels(mappedNodeId);
    }

    @Override
    public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
        this.first.forEachNodeLabel(mappedNodeId, consumer);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.first.availableNodeLabels();
    }

    @Override
    public boolean hasLabel(long mappedNodeId, NodeLabel label) {
        return this.first.hasLabel(mappedNodeId, label);
    }

    public boolean isNodeFilteredGraph() {
        return this.first instanceof NodeFilteredGraph;
    }

    private static class ParallelRelationshipDegreeCounter
    implements RelationshipConsumer {
        private final BitSet visited = BitSet.newInstance();

        ParallelRelationshipDegreeCounter() {
        }

        @Override
        public boolean accept(long s, long t) {
            this.visited.set(t);
            return true;
        }

        int degree() {
            return Math.toIntExact(this.visited.cardinality());
        }
    }
}

