/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.PropertyCursor;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.MutableIntValue;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.mem.MemoryUsage;

public final class UncompressedAdjacencyList
implements AdjacencyList,
AdjacencyProperties {
    private long[][] pages;
    private HugeIntArray degrees;
    private HugeLongArray offsets;

    public static MemoryEstimation adjacencyListEstimation(RelationshipType relationshipType, boolean undirected) {
        return MemoryEstimations.setup((String)"", dimensions -> UncompressedAdjacencyList.adjacencyListEstimation(UncompressedAdjacencyList.averageDegree(dimensions, relationshipType, undirected), dimensions.nodeCount()));
    }

    @TestOnly
    public static MemoryEstimation adjacencyListEstimation(boolean undirected) {
        return UncompressedAdjacencyList.adjacencyListEstimation(RelationshipType.ALL_RELATIONSHIPS, undirected);
    }

    public static MemoryEstimation adjacencyListEstimation(long avgDegree, long nodeCount) {
        return MemoryEstimations.builder(UncompressedAdjacencyList.class).fixed("pages", UncompressedAdjacencyList.listSize(avgDegree, nodeCount)).perNode("degrees", HugeIntArray::memoryEstimation).perNode("offsets", HugeLongArray::memoryEstimation).build();
    }

    public static MemoryEstimation adjacencyPropertiesEstimation(RelationshipType relationshipType, boolean undirected) {
        return MemoryEstimations.builder(UncompressedAdjacencyList.class).perGraphDimension("pages", (dimensions, concurrency) -> UncompressedAdjacencyList.listSize(UncompressedAdjacencyList.averageDegree(dimensions, relationshipType, undirected), dimensions.nodeCount())).perNode("offsets", HugeLongArray::memoryEstimation).build();
    }

    private static long averageDegree(GraphDimensions dimensions, RelationshipType relationshipType, boolean undirected) {
        long nodeCount = dimensions.nodeCount();
        long relCountForType = dimensions.relationshipCounts().getOrDefault(relationshipType, dimensions.relCountUpperBound());
        long relCount = undirected ? relCountForType * 2L : relCountForType;
        return nodeCount > 0L ? BitUtil.ceilDiv((long)relCount, (long)nodeCount) : 0L;
    }

    private static MemoryRange listSize(long avgDegree, long nodeCount) {
        long uncompressedAdjacencySize = nodeCount * avgDegree * 8L;
        int pages = PageUtil.numPagesFor((long)uncompressedAdjacencySize, (int)18, (long)262143L);
        long bytesPerPage = MemoryUsage.sizeOfByteArray((long)262144L);
        return MemoryRange.of((long)((long)pages * bytesPerPage + MemoryUsage.sizeOfObjectArray((long)pages)));
    }

    public UncompressedAdjacencyList(long[][] pages, HugeIntArray degrees, HugeLongArray offsets) {
        this.pages = pages;
        this.degrees = degrees;
        this.offsets = offsets;
    }

    @Override
    public int degree(long node) {
        return this.degrees.get(node);
    }

    @Override
    public AdjacencyCursor adjacencyCursor(long node, double fallbackValue) {
        int degree = this.degrees.get(node);
        if (degree == 0) {
            return AdjacencyCursor.empty();
        }
        Cursor cursor = new Cursor(this.pages);
        long offset = this.offsets.get(node);
        cursor.init(offset, degree);
        return cursor;
    }

    @Override
    public AdjacencyCursor adjacencyCursor(@Nullable AdjacencyCursor reuse, long node, double fallbackValue) {
        int degree = this.degrees.get(node);
        if (degree == 0) {
            return AdjacencyCursor.empty();
        }
        if (reuse instanceof Cursor) {
            reuse.init(this.offsets.get(node), degree);
            return reuse;
        }
        return this.adjacencyCursor(node, fallbackValue);
    }

    @Override
    public AdjacencyCursor rawAdjacencyCursor() {
        return new Cursor(this.pages);
    }

    @Override
    public void close() {
        this.pages = null;
        this.degrees = null;
        this.offsets = null;
    }

    @Override
    public PropertyCursor propertyCursor(long node, double fallbackValue) {
        int degree = this.degrees.get(node);
        if (degree == 0) {
            return PropertyCursor.empty();
        }
        Cursor cursor = new Cursor(this.pages);
        long offset = this.offsets.get(node);
        cursor.init(offset, degree);
        return cursor;
    }

    @Override
    public PropertyCursor propertyCursor(PropertyCursor reuse, long node, double fallbackValue) {
        int degree = this.degrees.get(node);
        if (degree == 0) {
            return PropertyCursor.empty();
        }
        if (reuse instanceof Cursor) {
            reuse.init(this.offsets.get(node), degree);
            return reuse;
        }
        return this.propertyCursor(node, fallbackValue);
    }

    @Override
    public PropertyCursor rawPropertyCursor() {
        return new Cursor(this.pages);
    }

    public static final class Cursor
    extends MutableIntValue
    implements AdjacencyCursor,
    PropertyCursor {
        private long[][] pages;
        private long[] currentPage;
        private int degree;
        private int limit;
        private int offset;

        private Cursor(long[][] pages) {
            this.pages = pages;
        }

        @Override
        public void init(long fromIndex, int degree) {
            this.currentPage = this.pages[PageUtil.pageIndex((long)fromIndex, (int)18)];
            this.offset = PageUtil.indexInPage((long)fromIndex, (long)262143L);
            this.limit = this.offset + degree;
            this.degree = degree;
        }

        @Override
        public boolean hasNextLong() {
            return this.offset < this.limit;
        }

        @Override
        public long nextLong() {
            return this.currentPage[this.offset++];
        }

        @Override
        public int size() {
            return this.degree;
        }

        @Override
        public int remaining() {
            return this.limit - this.offset;
        }

        @Override
        public boolean hasNextVLong() {
            return this.offset < this.limit;
        }

        @Override
        public long nextVLong() {
            return this.currentPage[this.offset++];
        }

        @Override
        public long peekVLong() {
            return this.currentPage[this.offset];
        }

        @Override
        @NotNull
        public AdjacencyCursor shallowCopy(@Nullable AdjacencyCursor destination) {
            Cursor dest = destination instanceof Cursor ? (Cursor)destination : new Cursor(this.pages);
            dest.currentPage = this.currentPage;
            dest.degree = this.degree;
            dest.limit = this.limit;
            dest.offset = this.offset;
            return dest;
        }

        @Override
        public long skipUntil(long target) {
            long value;
            if (this.remaining() <= 0) {
                return -1L;
            }
            int idx = ArrayUtil.binarySearchLast(this.currentPage, this.offset, this.limit, target);
            if (idx >= 0) {
                this.offset = idx;
                if (this.offset + 1 < this.limit) {
                    value = this.currentPage[this.offset + 1];
                    this.offset += 2;
                } else {
                    value = this.currentPage[this.offset++];
                }
            } else {
                this.offset = -idx - 1;
                value = this.offset < this.limit ? this.currentPage[this.offset++] : this.currentPage[this.offset - 1];
            }
            return value;
        }

        @Override
        public long advance(long target) {
            if (this.remaining() <= 0) {
                return -1L;
            }
            int idx = ArrayUtil.binarySearchFirst(this.currentPage, this.offset, this.limit, target);
            if (idx >= 0) {
                this.offset = idx;
            } else {
                this.offset = -idx - 1;
                if (this.offset == 0 || this.offset >= this.limit) {
                    this.offset = this.limit;
                    return this.currentPage[this.offset - 1];
                }
            }
            return this.currentPage[this.offset++];
        }

        @Override
        public long advanceBy(int n) {
            assert (n >= 0);
            this.offset += n;
            if (this.offset >= this.limit) {
                this.offset = this.limit;
                return -1L;
            }
            return this.currentPage[this.offset];
        }

        @Override
        public void close() {
            this.pages = null;
            this.currentPage = null;
        }
    }
}

