/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.CSRGraphAdapter;
import org.neo4j.gds.api.FilteredIdMap;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.ImmutableRelationshipCursor;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipCursor;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.huge.FilteredNodePropertyValues;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.utils.CloseableThreadLocal;

public class NodeFilteredGraph
extends CSRGraphAdapter
implements FilteredIdMap {
    private static final int NO_DEGREE = -1;
    private final FilteredIdMap filteredIdMap;
    private long relationshipCount;
    private final HugeIntArray degreeCache;
    private final CloseableThreadLocal<Graph> threadLocalGraph;

    public NodeFilteredGraph(CSRGraph originalGraph, FilteredIdMap filteredIdMap) {
        this(originalGraph, filteredIdMap, NodeFilteredGraph.emptyDegreeCache(filteredIdMap), -1L);
    }

    private NodeFilteredGraph(CSRGraph originalGraph, FilteredIdMap filteredIdMap, HugeIntArray degreeCache, long relationshipCount) {
        super(originalGraph);
        this.degreeCache = degreeCache;
        this.filteredIdMap = filteredIdMap;
        this.relationshipCount = relationshipCount;
        this.threadLocalGraph = CloseableThreadLocal.withInitial(this::concurrentCopy);
    }

    private static HugeIntArray emptyDegreeCache(IdMap filteredIdMap) {
        HugeIntArray degreeCache = HugeIntArray.newArray(filteredIdMap.nodeCount());
        degreeCache.fill(-1);
        return degreeCache;
    }

    @Override
    public GraphSchema schema() {
        return this.csrGraph.schema().filterNodeLabels(this.filteredIdMap.availableNodeLabels());
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator() {
        return this.filteredIdMap.nodeIterator();
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Set<NodeLabel> labels) {
        return this.filteredIdMap.nodeIterator(labels);
    }

    @Override
    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return this.filteredIdMap.batchIterables(batchSize);
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        this.filteredIdMap.forEachNode(consumer);
    }

    @Override
    public int degree(long nodeId) {
        int cachedDegree = this.degreeCache.get(nodeId);
        if (cachedDegree != -1) {
            return cachedDegree;
        }
        MutableInt degree = new MutableInt();
        this.threadLocalGraph.get().forEachRelationship(nodeId, (s, t) -> {
            degree.increment();
            return true;
        });
        this.degreeCache.set(nodeId, degree.intValue());
        return degree.intValue();
    }

    @Override
    public int degreeWithoutParallelRelationships(long nodeId) {
        NonDuplicateRelationshipsDegreeCounter degreeCounter = new NonDuplicateRelationshipsDegreeCounter();
        this.forEachRelationship(nodeId, degreeCounter);
        return degreeCounter.degree;
    }

    @Override
    public long nodeCount() {
        return this.filteredIdMap.nodeCount();
    }

    @Override
    public OptionalLong rootNodeCount() {
        return this.filteredIdMap.rootNodeCount();
    }

    @Override
    public boolean containsRootNodeId(long rootNodeId) {
        return this.filteredIdMap.containsRootNodeId(rootNodeId);
    }

    @Override
    public long relationshipCount() {
        if (this.relationshipCount == -1L) {
            this.doCount();
        }
        return this.relationshipCount;
    }

    private void doCount() {
        List<RelationshipCounter> tasks = PartitionUtils.rangePartition(4, this.nodeCount(), partition -> new RelationshipCounter(this.concurrentCopy(), (Partition)partition), Optional.empty());
        RunWithConcurrency.builder().concurrency(4).tasks(tasks).run();
        this.relationshipCount = tasks.stream().mapToLong(RelationshipCounter::relationshipCount).sum();
    }

    @Override
    public long highestNeoId() {
        return this.filteredIdMap.highestNeoId();
    }

    @Override
    public long toMappedNodeId(long originalNodeId) {
        return this.filteredIdMap.toMappedNodeId(originalNodeId);
    }

    @Override
    public long toRootNodeId(long mappedNodeId) {
        return this.filteredIdMap.toRootNodeId(mappedNodeId);
    }

    @Override
    public long rootToMappedNodeId(long rootNodeId) {
        return this.filteredIdMap.rootToMappedNodeId(rootNodeId);
    }

    @Override
    public boolean contains(long originalNodeId) {
        return this.filteredIdMap.contains(originalNodeId);
    }

    @Override
    public long toOriginalNodeId(long mappedNodeId) {
        return this.filteredIdMap.toOriginalNodeId(mappedNodeId);
    }

    @Override
    public void forEachRelationship(long nodeId, RelationshipConsumer consumer) {
        super.forEachRelationship(this.filteredIdMap.toRootNodeId(nodeId), (s, t) -> this.filterAndConsume(s, t, consumer));
    }

    @Override
    public void forEachRelationship(long nodeId, double fallbackValue, RelationshipWithPropertyConsumer consumer) {
        super.forEachRelationship(this.filteredIdMap.toRootNodeId(nodeId), fallbackValue, (s, t, p) -> this.filterAndConsume(s, t, p, consumer));
    }

    @Override
    public Stream<RelationshipCursor> streamRelationships(long nodeId, double fallbackValue) {
        return super.streamRelationships(this.filteredIdMap.toRootNodeId(nodeId), fallbackValue).filter(rel -> this.filteredIdMap.containsRootNodeId(rel.sourceId()) && this.filteredIdMap.containsRootNodeId(rel.targetId())).map(rel -> ImmutableRelationshipCursor.of(this.filteredIdMap.rootToMappedNodeId(rel.sourceId()), this.filteredIdMap.rootToMappedNodeId(rel.targetId()), rel.property()));
    }

    public long getFilteredMappedNodeId(long nodeId) {
        return this.filteredIdMap.rootToMappedNodeId(nodeId);
    }

    long getIntermediateOriginalNodeId(long nodeId) {
        return this.filteredIdMap.toRootNodeId(nodeId);
    }

    @Override
    public Optional<NodeFilteredGraph> asNodeFilteredGraph() {
        return Optional.of(this);
    }

    @Override
    public boolean exists(long sourceNodeId, long targetNodeId) {
        return super.exists(this.filteredIdMap.toRootNodeId(sourceNodeId), this.filteredIdMap.toRootNodeId(targetNodeId));
    }

    @Override
    public long nthTarget(long nodeId, int offset) {
        return Graph.nthTarget(this, nodeId, offset);
    }

    @Override
    public double relationshipProperty(long sourceNodeId, long targetNodeId, double fallbackValue) {
        return super.relationshipProperty(this.filteredIdMap.toRootNodeId(sourceNodeId), this.filteredIdMap.toRootNodeId(targetNodeId), fallbackValue);
    }

    @Override
    public double relationshipProperty(long sourceNodeId, long targetNodeId) {
        return super.relationshipProperty(this.filteredIdMap.toRootNodeId(sourceNodeId), this.filteredIdMap.toRootNodeId(targetNodeId));
    }

    @Override
    public CSRGraph concurrentCopy() {
        return new NodeFilteredGraph(this.csrGraph.concurrentCopy(), this.filteredIdMap, this.degreeCache, this.relationshipCount);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.filteredIdMap.availableNodeLabels();
    }

    @Override
    public List<NodeLabel> nodeLabels(long mappedNodeId) {
        return this.filteredIdMap.nodeLabels(mappedNodeId);
    }

    @Override
    public boolean hasLabel(long mappedNodeId, NodeLabel label) {
        return this.filteredIdMap.hasLabel(mappedNodeId, label);
    }

    @Override
    public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
        this.filteredIdMap.forEachNodeLabel(mappedNodeId, consumer);
    }

    @Override
    public Optional<? extends FilteredIdMap> withFilteredLabels(Collection<NodeLabel> nodeLabels, int concurrency) {
        return this.filteredIdMap.withFilteredLabels(nodeLabels, concurrency);
    }

    @Override
    public NodePropertyValues nodeProperties(String propertyKey) {
        NodePropertyValues properties = this.csrGraph.nodeProperties(propertyKey);
        if (properties == null) {
            return null;
        }
        return new FilteredNodePropertyValues.FilteredToOriginalNodePropertyValues(properties, this);
    }

    @Override
    public void release() {
        super.release();
        this.threadLocalGraph.close();
    }

    private boolean filterAndConsume(long source, long target, RelationshipConsumer consumer) {
        if (this.filteredIdMap.containsRootNodeId(source) && this.filteredIdMap.containsRootNodeId(target)) {
            long internalSourceId = this.filteredIdMap.rootToMappedNodeId(source);
            long internalTargetId = this.filteredIdMap.rootToMappedNodeId(target);
            return consumer.accept(internalSourceId, internalTargetId);
        }
        return true;
    }

    private boolean filterAndConsume(long source, long target, double propertyValue, RelationshipWithPropertyConsumer consumer) {
        if (this.filteredIdMap.containsRootNodeId(source) && this.filteredIdMap.containsRootNodeId(target)) {
            long internalSourceId = this.filteredIdMap.rootToMappedNodeId(source);
            long internalTargetId = this.filteredIdMap.rootToMappedNodeId(target);
            return consumer.accept(internalSourceId, internalTargetId, propertyValue);
        }
        return true;
    }

    private static class NonDuplicateRelationshipsDegreeCounter
    implements RelationshipConsumer {
        private long previousNodeId = -1L;
        private int degree;

        NonDuplicateRelationshipsDegreeCounter() {
        }

        @Override
        public boolean accept(long s, long t) {
            if (t != this.previousNodeId) {
                ++this.degree;
                this.previousNodeId = t;
            }
            return true;
        }
    }

    static class RelationshipCounter
    implements Runnable {
        private long relationshipCount;
        private final Graph graph;
        private final Partition partition;

        RelationshipCounter(Graph graph, Partition partition) {
            this.partition = partition;
            this.graph = graph;
            this.relationshipCount = 0L;
        }

        @Override
        public void run() {
            this.partition.consume(nodeId -> this.graph.forEachRelationship(nodeId, (src, target) -> {
                ++this.relationshipCount;
                return true;
            }));
        }

        long relationshipCount() {
            return this.relationshipCount;
        }
    }
}

