/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.utils.StringFormatting;

public class NodeFilteredAdjacencyCursor
implements AdjacencyCursor {
    private final AdjacencyCursor innerCursor;
    private final IdMap idMap;
    private long nextLongValue;

    NodeFilteredAdjacencyCursor(AdjacencyCursor innerCursor, IdMap idMap) {
        this.innerCursor = innerCursor;
        this.idMap = idMap;
        this.nextLongValue = -1L;
    }

    @Override
    public void init(long index, int degree) {
        this.innerCursor.init(index, degree);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"AdjacencyCursor#size is not implemented for %s", (Object[])new Object[]{this.getClass().getSimpleName()}));
    }

    @Override
    public boolean hasNextVLong() {
        if (this.innerCursor.hasNextVLong()) {
            long innerNextLong = this.innerCursor.peekVLong();
            if (!this.idMap.contains(innerNextLong)) {
                this.innerCursor.nextVLong();
                return this.hasNextVLong();
            }
            this.nextLongValue = this.idMap.toMappedNodeId(innerNextLong);
            return true;
        }
        return false;
    }

    @Override
    public long nextVLong() {
        if (this.innerCursor.hasNextVLong()) {
            this.innerCursor.nextVLong();
        }
        return this.nextLongValue;
    }

    @Override
    public long peekVLong() {
        return this.nextLongValue;
    }

    @Override
    public int remaining() {
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"AdjacencyCursor#remaining is not implemented for %s", (Object[])new Object[]{this.getClass().getSimpleName()}));
    }

    @Override
    public long skipUntil(long nodeId) {
        while (this.nextLongValue <= nodeId) {
            if (this.hasNextVLong()) {
                this.nextVLong();
                continue;
            }
            return -1L;
        }
        return this.nextLongValue;
    }

    @Override
    public long advance(long nodeId) {
        while (this.nextLongValue < nodeId) {
            if (this.hasNextVLong()) {
                this.nextVLong();
                continue;
            }
            return -1L;
        }
        return this.nextLongValue;
    }

    @Override
    public long advanceBy(int n) {
        assert (n >= 0);
        while (this.hasNextVLong()) {
            this.nextVLong();
            if (n-- != 0) continue;
            return this.nextLongValue;
        }
        return -1L;
    }

    @Override
    @NotNull
    public AdjacencyCursor shallowCopy(@Nullable AdjacencyCursor destination) {
        return new NodeFilteredAdjacencyCursor(this.innerCursor.shallowCopy(destination), this.idMap);
    }

    @Override
    public void close() {
        this.innerCursor.close();
    }
}

