/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.LongPredicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.FilteredIdMap;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PropertyCursor;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipCursor;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.huge.AdjacencySpliterator;
import org.neo4j.gds.core.huge.NodeFilteredGraph;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.utils.StringFormatting;

public class HugeGraph
implements CSRGraph {
    static final double NO_PROPERTY_VALUE = Double.NaN;
    protected final IdMap idMap;
    protected final GraphSchema schema;
    protected final Map<String, NodePropertyValues> nodeProperties;
    protected final Orientation orientation;
    protected final long relationshipCount;
    protected AdjacencyList adjacency;
    private final double defaultPropertyValue;
    @Nullable
    protected AdjacencyProperties properties;
    private AdjacencyCursor adjacencyCursorCache;
    private PropertyCursor propertyCursorCache;
    private boolean canRelease = true;
    protected final boolean hasRelationshipProperty;
    protected final boolean isMultiGraph;

    public static HugeGraph create(IdMap nodes, GraphSchema schema, Map<String, NodePropertyValues> nodeProperties, Relationships.Topology topology, Optional<Relationships.Properties> maybeRelationshipProperty) {
        return new HugeGraph(nodes, schema, nodeProperties, topology.elementCount(), topology.adjacencyList(), maybeRelationshipProperty.isPresent(), maybeRelationshipProperty.map(Relationships.Properties::defaultPropertyValue).orElse(Double.NaN), maybeRelationshipProperty.map(Relationships.Properties::propertiesList).orElse(null), topology.orientation(), topology.isMultiGraph());
    }

    protected HugeGraph(IdMap idMap, GraphSchema schema, Map<String, NodePropertyValues> nodeProperties, long relationshipCount, @NotNull AdjacencyList adjacency, boolean hasRelationshipProperty, double defaultRelationshipPropertyValue, @Nullable AdjacencyProperties relationshipProperty, Orientation orientation, boolean isMultiGraph) {
        this.idMap = idMap;
        this.schema = schema;
        this.isMultiGraph = isMultiGraph;
        this.nodeProperties = nodeProperties;
        this.relationshipCount = relationshipCount;
        this.adjacency = adjacency;
        this.defaultPropertyValue = defaultRelationshipPropertyValue;
        this.properties = relationshipProperty;
        this.orientation = orientation;
        this.hasRelationshipProperty = hasRelationshipProperty;
        this.adjacencyCursorCache = adjacency.rawAdjacencyCursor();
        this.propertyCursorCache = relationshipProperty != null ? relationshipProperty.rawPropertyCursor() : null;
    }

    @Override
    public long nodeCount() {
        return this.idMap.nodeCount();
    }

    @Override
    public OptionalLong rootNodeCount() {
        return this.idMap.rootNodeCount();
    }

    @Override
    public long highestNeoId() {
        return this.idMap.highestNeoId();
    }

    public IdMap idMap() {
        return this.idMap;
    }

    @Override
    public IdMap rootIdMap() {
        return this.idMap.rootIdMap();
    }

    @Override
    public GraphSchema schema() {
        return this.schema;
    }

    public Map<String, NodePropertyValues> nodeProperties() {
        return this.nodeProperties;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return this.idMap.batchIterables(batchSize);
    }

    @Override
    public void forEachNode(LongPredicate consumer) {
        this.idMap.forEachNode(consumer);
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator() {
        return this.idMap.nodeIterator();
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Set<NodeLabel> labels) {
        return this.idMap.nodeIterator(labels);
    }

    @Override
    public double relationshipProperty(long sourceNodeId, long targetNodeId) {
        return this.relationshipProperty(sourceNodeId, targetNodeId, this.defaultPropertyValue);
    }

    @Override
    public double relationshipProperty(long sourceId, long targetId, double fallbackValue) {
        double maybeValue;
        if (!this.hasRelationshipProperty) {
            return fallbackValue;
        }
        if (this.properties != null && !Double.isNaN(maybeValue = this.findPropertyValue(sourceId, targetId))) {
            return maybeValue;
        }
        return this.defaultPropertyValue;
    }

    private double findPropertyValue(long fromId, long toId) {
        AdjacencyProperties properties = Objects.requireNonNull(this.properties);
        AdjacencyCursor adjacencyCursor = this.adjacency.adjacencyCursor(fromId);
        if (!adjacencyCursor.hasNextVLong()) {
            return Double.NaN;
        }
        PropertyCursor propertyCursor = properties.propertyCursor(fromId, this.defaultPropertyValue);
        while (adjacencyCursor.hasNextVLong() && propertyCursor.hasNextLong() && adjacencyCursor.nextVLong() != toId) {
            propertyCursor.nextLong();
        }
        if (!propertyCursor.hasNextLong()) {
            return Double.NaN;
        }
        long doubleBits = propertyCursor.nextLong();
        return Double.longBitsToDouble(doubleBits);
    }

    @Override
    public NodePropertyValues nodeProperties(String propertyKey) {
        return this.nodeProperties.get(propertyKey);
    }

    @Override
    public Set<String> availableNodeProperties() {
        return this.nodeProperties.keySet();
    }

    @Override
    public void forEachRelationship(long nodeId, RelationshipConsumer consumer) {
        this.runForEach(nodeId, consumer);
    }

    @Override
    public void forEachRelationship(long nodeId, double fallbackValue, RelationshipWithPropertyConsumer consumer) {
        this.runForEach(nodeId, fallbackValue, consumer);
    }

    @Override
    public Stream<RelationshipCursor> streamRelationships(long nodeId, double fallbackValue) {
        AdjacencyCursor adjacencyCursor = this.adjacencyCursorForIteration(nodeId);
        Spliterator<RelationshipCursor> spliterator = !this.hasRelationshipProperty() ? AdjacencySpliterator.of(adjacencyCursor, nodeId, fallbackValue) : AdjacencySpliterator.of(adjacencyCursor, this.propertyCursorForIteration(nodeId), nodeId);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public Graph relationshipTypeFilteredGraph(Set<RelationshipType> relationshipTypes) {
        this.assertSupportedRelationships(relationshipTypes);
        return this;
    }

    @Override
    public Map<RelationshipType, Relationships.Topology> relationshipTopologies() {
        return Map.of(this.relationshipType(), this.relationshipTopology());
    }

    public Relationships.Topology relationshipTopology() {
        return this.relationships().topology();
    }

    private void assertSupportedRelationships(Set<RelationshipType> relationshipTypes) {
        if (!(relationshipTypes.isEmpty() || relationshipTypes.size() <= 1 && relationshipTypes.contains(this.relationshipType()))) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"One or more relationship types of %s in are not supported. This graph has a relationship of type %s.", (Object[])new Object[]{relationshipTypes, this.relationshipType()}));
        }
    }

    private RelationshipType relationshipType() {
        return (RelationshipType)this.schema().relationshipSchema().availableTypes().iterator().next();
    }

    @Override
    public int degree(long node) {
        return this.adjacency.degree(node);
    }

    @Override
    public int degreeWithoutParallelRelationships(long nodeId) {
        if (!this.isMultiGraph()) {
            return this.degree(nodeId);
        }
        ParallelRelationshipsDegreeCounter degreeCounter = new ParallelRelationshipsDegreeCounter();
        this.runForEach(nodeId, degreeCounter);
        return degreeCounter.degree;
    }

    @Override
    public long toMappedNodeId(long originalNodeId) {
        return this.idMap.toMappedNodeId(originalNodeId);
    }

    @Override
    public long toOriginalNodeId(long mappedNodeId) {
        return this.idMap.toOriginalNodeId(mappedNodeId);
    }

    @Override
    public long toRootNodeId(long mappedNodeId) {
        return this.idMap.toRootNodeId(mappedNodeId);
    }

    @Override
    public boolean contains(long originalNodeId) {
        return this.idMap.contains(originalNodeId);
    }

    @Override
    public HugeGraph concurrentCopy() {
        return new HugeGraph(this.idMap, this.schema, this.nodeProperties, this.relationshipCount, this.adjacency, this.hasRelationshipProperty, this.defaultPropertyValue, this.properties, this.orientation, this.isMultiGraph);
    }

    @Override
    public Optional<NodeFilteredGraph> asNodeFilteredGraph() {
        return Optional.empty();
    }

    @Override
    public boolean exists(long sourceNodeId, long targetNodeId) {
        AdjacencyCursor cursor = this.adjacencyCursorForIteration(sourceNodeId);
        return cursor.advance(targetNodeId) == targetNodeId;
    }

    @Override
    public long nthTarget(long nodeId, int offset) {
        if (offset >= this.degree(nodeId)) {
            return -1L;
        }
        AdjacencyCursor cursor = this.adjacencyCursorForIteration(nodeId);
        return cursor.advanceBy(offset);
    }

    private void runForEach(long sourceId, RelationshipConsumer consumer) {
        AdjacencyCursor adjacencyCursor = this.adjacencyCursorForIteration(sourceId);
        this.consumeAdjacentNodes(sourceId, adjacencyCursor, consumer);
    }

    private void runForEach(long sourceId, double fallbackValue, RelationshipWithPropertyConsumer consumer) {
        if (!this.hasRelationshipProperty()) {
            this.runForEach(sourceId, (s, t) -> consumer.accept(s, t, fallbackValue));
        } else {
            AdjacencyCursor adjacencyCursor = this.adjacencyCursorForIteration(sourceId);
            PropertyCursor propertyCursor = this.propertyCursorForIteration(sourceId);
            this.consumeAdjacentNodesWithProperty(sourceId, adjacencyCursor, propertyCursor, consumer);
        }
    }

    private AdjacencyCursor adjacencyCursorForIteration(long sourceNodeId) {
        return this.adjacency.adjacencyCursor(this.adjacencyCursorCache, sourceNodeId);
    }

    private PropertyCursor propertyCursorForIteration(long sourceNodeId) {
        if (!this.hasRelationshipProperty() || this.properties == null) {
            throw new UnsupportedOperationException("Can not create property cursor on a graph without relationship property");
        }
        return this.properties.propertyCursor(this.propertyCursorCache, sourceNodeId, this.defaultPropertyValue);
    }

    @Override
    public void canRelease(boolean canRelease) {
        this.canRelease = canRelease;
    }

    @Override
    public void releaseTopology() {
        if (!this.canRelease) {
            return;
        }
        if (this.adjacency != null) {
            this.adjacency.close();
            this.adjacency = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
        if (this.adjacencyCursorCache != null) {
            this.adjacencyCursorCache.close();
            this.adjacencyCursorCache = null;
        }
        if (this.propertyCursorCache != null) {
            this.propertyCursorCache.close();
            this.propertyCursorCache = null;
        }
    }

    @Override
    public void releaseProperties() {
        if (this.canRelease) {
            for (NodePropertyValues idMap : this.nodeProperties.values()) {
                idMap.release();
            }
        }
    }

    @Override
    public boolean isMultiGraph() {
        return this.isMultiGraph;
    }

    public Relationships relationships() {
        return Relationships.of(this.relationshipCount, this.orientation, this.isMultiGraph(), this.adjacency, this.properties, this.defaultPropertyValue);
    }

    @Override
    public boolean hasRelationshipProperty() {
        return this.hasRelationshipProperty;
    }

    private void consumeAdjacentNodes(long sourceId, AdjacencyCursor adjacencyCursor, RelationshipConsumer consumer) {
        while (adjacencyCursor.hasNextVLong() && consumer.accept(sourceId, adjacencyCursor.nextVLong())) {
        }
    }

    private void consumeAdjacentNodesWithProperty(long sourceId, AdjacencyCursor adjacencyCursor, PropertyCursor propertyCursor, RelationshipWithPropertyConsumer consumer) {
        long propertyBits;
        double property;
        long targetId;
        while (adjacencyCursor.hasNextVLong() && consumer.accept(sourceId, targetId = adjacencyCursor.nextVLong(), property = Double.longBitsToDouble(propertyBits = propertyCursor.nextLong()))) {
        }
    }

    @Override
    public List<NodeLabel> nodeLabels(long mappedNodeId) {
        return this.idMap.nodeLabels(mappedNodeId);
    }

    @Override
    public void forEachNodeLabel(long mappedNodeId, IdMap.NodeLabelConsumer consumer) {
        this.idMap.forEachNodeLabel(mappedNodeId, consumer);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.idMap.availableNodeLabels();
    }

    @Override
    public boolean hasLabel(long mappedNodeId, NodeLabel label) {
        return this.idMap.hasLabel(mappedNodeId, label);
    }

    @Override
    public Optional<? extends FilteredIdMap> withFilteredLabels(Collection<NodeLabel> nodeLabels, int concurrency) {
        return this.idMap.withFilteredLabels(nodeLabels, concurrency);
    }

    private static class ParallelRelationshipsDegreeCounter
    implements RelationshipConsumer {
        private long previousNodeId = -1L;
        private int degree;

        ParallelRelationshipsDegreeCounter() {
        }

        @Override
        public boolean accept(long s, long t) {
            if (t != this.previousNodeId) {
                ++this.degree;
                this.previousNodeId = t;
            }
            return true;
        }
    }
}

