/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.huge.NodeFilteredGraph;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class FilteredNodePropertyValues
implements NodePropertyValues {
    protected final NodePropertyValues properties;
    protected NodeFilteredGraph graph;

    protected abstract long translateId(long var1);

    FilteredNodePropertyValues(NodePropertyValues properties, NodeFilteredGraph graph) {
        this.properties = properties;
        this.graph = graph;
    }

    @Override
    public double doubleValue(long nodeId) {
        return this.properties.doubleValue(this.translateId(nodeId));
    }

    @Override
    public long longValue(long nodeId) {
        return this.properties.longValue(this.translateId(nodeId));
    }

    @Override
    public float[] floatArrayValue(long nodeId) {
        return this.properties.floatArrayValue(this.translateId(nodeId));
    }

    @Override
    public double[] doubleArrayValue(long nodeId) {
        return this.properties.doubleArrayValue(this.translateId(nodeId));
    }

    @Override
    public long[] longArrayValue(long nodeId) {
        return this.properties.longArrayValue(this.translateId(nodeId));
    }

    @Override
    public Object getObject(long nodeId) {
        return this.properties.getObject(this.translateId(nodeId));
    }

    @Override
    public Value value(long nodeId) {
        return this.properties.value(this.translateId(nodeId));
    }

    @Override
    public ValueType valueType() {
        return this.properties.valueType();
    }

    @Override
    public OptionalLong getMaxLongPropertyValue() {
        if (this.valueType() == ValueType.LONG) {
            MutableLong currentMax = new MutableLong(Long.MIN_VALUE);
            this.graph.forEachNode(id -> {
                currentMax.setValue((Number)Math.max(currentMax.doubleValue(), (double)this.longValue(id)));
                return true;
            });
            return currentMax.longValue() == Long.MIN_VALUE ? OptionalLong.empty() : OptionalLong.of(currentMax.longValue());
        }
        if (this.valueType() == ValueType.DOUBLE) {
            MutableDouble currentMax = new MutableDouble(Double.NEGATIVE_INFINITY);
            this.graph.forEachNode(id -> {
                currentMax.setValue(Math.max(currentMax.doubleValue(), this.doubleValue(id)));
                return true;
            });
            return currentMax.doubleValue() == Double.NEGATIVE_INFINITY ? OptionalLong.empty() : OptionalLong.of(currentMax.toDouble().longValue());
        }
        return OptionalLong.empty();
    }

    @Override
    public OptionalDouble getMaxDoublePropertyValue() {
        if (this.valueType() == ValueType.LONG) {
            MutableLong currentMax = new MutableLong(Long.MIN_VALUE);
            this.graph.forEachNode(id -> {
                currentMax.setValue((Number)Math.max(currentMax.doubleValue(), (double)this.longValue(id)));
                return true;
            });
            return currentMax.longValue() == Long.MIN_VALUE ? OptionalDouble.empty() : OptionalDouble.of(currentMax.toLong().doubleValue());
        }
        if (this.valueType() == ValueType.DOUBLE) {
            MutableDouble currentMax = new MutableDouble(Double.NEGATIVE_INFINITY);
            this.graph.forEachNode(id -> {
                currentMax.setValue(Math.max(currentMax.doubleValue(), this.doubleValue(id)));
                return true;
            });
            return currentMax.doubleValue() == Double.NEGATIVE_INFINITY ? OptionalDouble.empty() : OptionalDouble.of(currentMax.doubleValue());
        }
        return OptionalDouble.empty();
    }

    @Override
    public long release() {
        long releasedFromProps = this.properties.release();
        this.graph = null;
        return releasedFromProps;
    }

    @Override
    public long size() {
        return Math.min(this.properties.size(), this.graph.nodeCount());
    }

    public static class OriginalToFilteredNodePropertyValues
    extends FilteredNodePropertyValues {
        public OriginalToFilteredNodePropertyValues(NodePropertyValues properties, NodeFilteredGraph graph) {
            super(properties, graph);
        }

        @Override
        public double doubleValue(long nodeId) {
            long translatedId = this.translateId(nodeId);
            if (translatedId < 0L) {
                return Double.NaN;
            }
            return this.properties.doubleValue(translatedId);
        }

        @Override
        public long longValue(long nodeId) {
            long translatedId = this.translateId(nodeId);
            if (translatedId < 0L) {
                return Long.MIN_VALUE;
            }
            return this.properties.longValue(translatedId);
        }

        @Override
        public float[] floatArrayValue(long nodeId) {
            long translatedId = this.translateId(nodeId);
            if (translatedId < 0L) {
                return DefaultValue.DEFAULT.floatArrayValue();
            }
            return this.properties.floatArrayValue(translatedId);
        }

        @Override
        public double[] doubleArrayValue(long nodeId) {
            long translatedId = this.translateId(nodeId);
            if (translatedId < 0L) {
                return DefaultValue.DEFAULT.doubleArrayValue();
            }
            return this.properties.doubleArrayValue(translatedId);
        }

        @Override
        public long[] longArrayValue(long nodeId) {
            long translatedId = this.translateId(nodeId);
            if (translatedId < 0L) {
                return DefaultValue.DEFAULT.longArrayValue();
            }
            return this.properties.longArrayValue(translatedId);
        }

        @Override
        public Object getObject(long nodeId) {
            long translatedId = this.translateId(nodeId);
            if (translatedId < 0L) {
                return null;
            }
            return this.properties.getObject(translatedId);
        }

        @Override
        public Value value(long nodeId) {
            long translatedId = this.translateId(nodeId);
            if (translatedId < 0L) {
                return Values.NO_VALUE;
            }
            return this.properties.value(translatedId);
        }

        @Override
        protected long translateId(long nodeId) {
            return this.graph.getFilteredMappedNodeId(nodeId);
        }
    }

    public static class FilteredToOriginalNodePropertyValues
    extends FilteredNodePropertyValues {
        public FilteredToOriginalNodePropertyValues(NodePropertyValues properties, NodeFilteredGraph graph) {
            super(properties, graph);
        }

        @Override
        protected long translateId(long nodeId) {
            return this.graph.getIntermediateOriginalNodeId(nodeId);
        }
    }
}

