/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.core.huge.AdjacencyDecompressingReader;
import org.neo4j.gds.core.loading.MutableIntValue;
import org.neo4j.gds.core.loading.VarLongEncoding;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.mem.MemoryUsage;

public final class CompressedAdjacencyList
implements AdjacencyList {
    private byte[][] pages;
    private HugeIntArray degrees;
    private HugeLongArray offsets;

    public static MemoryEstimation adjacencyListEstimation(RelationshipType relationshipType, boolean undirected) {
        return MemoryEstimations.setup((String)"", dimensions -> {
            long nodeCount = dimensions.nodeCount();
            long relCountForType = dimensions.relationshipCounts().getOrDefault(relationshipType, dimensions.relCountUpperBound());
            long relCount = undirected ? relCountForType * 2L : relCountForType;
            long avgDegree = nodeCount > 0L ? BitUtil.ceilDiv((long)relCount, (long)nodeCount) : 0L;
            return CompressedAdjacencyList.adjacencyListEstimation(avgDegree, nodeCount);
        });
    }

    public static MemoryEstimation adjacencyListEstimation(long avgDegree, long nodeCount) {
        int deltaBestCase = 1;
        long bestCaseAdjacencySize = CompressedAdjacencyList.computeAdjacencyByteSize(avgDegree, nodeCount, deltaBestCase);
        long deltaWorstCase = avgDegree > 0L ? BitUtil.ceilDiv((long)nodeCount, (long)avgDegree) : 0L;
        long worstCaseAdjacencySize = CompressedAdjacencyList.computeAdjacencyByteSize(avgDegree, nodeCount, deltaWorstCase);
        int minPages = PageUtil.numPagesFor((long)bestCaseAdjacencySize, (int)18, (long)262143L);
        int maxPages = PageUtil.numPagesFor((long)worstCaseAdjacencySize, (int)18, (long)262143L);
        long bytesPerPage = MemoryUsage.sizeOfByteArray((long)262144L);
        long minMemoryReqs = (long)minPages * bytesPerPage + MemoryUsage.sizeOfObjectArray((long)minPages);
        long maxMemoryReqs = (long)maxPages * bytesPerPage + MemoryUsage.sizeOfObjectArray((long)maxPages);
        MemoryRange pagesMemoryRange = MemoryRange.of((long)minMemoryReqs, (long)maxMemoryReqs);
        return MemoryEstimations.builder(CompressedAdjacencyList.class).fixed("pages", pagesMemoryRange).perNode("degrees", HugeIntArray::memoryEstimation).perNode("offsets", HugeLongArray::memoryEstimation).build();
    }

    @TestOnly
    public static MemoryEstimation adjacencyListEstimation(boolean undirected) {
        return CompressedAdjacencyList.adjacencyListEstimation(RelationshipType.ALL_RELATIONSHIPS, undirected);
    }

    static long computeAdjacencyByteSize(long avgDegree, long nodeCount, long delta) {
        long firstAdjacencyIdAvgByteSize = avgDegree > 0L ? (long)BitUtil.ceilDiv((int)VarLongEncoding.encodedVLongSize(nodeCount), (int)2) : 0L;
        int relationshipByteSize = VarLongEncoding.encodedVLongSize(delta);
        long compressedAdjacencyByteSize = (long)relationshipByteSize * Math.max(0L, avgDegree - 1L);
        return (firstAdjacencyIdAvgByteSize + compressedAdjacencyByteSize) * nodeCount;
    }

    public CompressedAdjacencyList(byte[][] pages, HugeIntArray degrees, HugeLongArray offsets) {
        this.pages = pages;
        this.degrees = degrees;
        this.offsets = offsets;
    }

    @Override
    public void close() {
        this.pages = null;
        this.degrees = null;
        this.offsets = null;
    }

    @Override
    public int degree(long node) {
        return this.degrees.get(node);
    }

    @Override
    public AdjacencyCursor adjacencyCursor(long node, double fallbackValue) {
        int degree = this.degrees.get(node);
        if (degree == 0) {
            return AdjacencyCursor.empty();
        }
        DecompressingCursor cursor = new DecompressingCursor(this.pages);
        long offset = this.offsets.get(node);
        cursor.init(offset, degree);
        return cursor;
    }

    @Override
    public AdjacencyCursor adjacencyCursor(@Nullable AdjacencyCursor reuse, long node, double fallbackValue) {
        int degree = this.degrees.get(node);
        if (degree == 0) {
            return AdjacencyCursor.empty();
        }
        if (reuse instanceof DecompressingCursor) {
            reuse.init(this.offsets.get(node), degree);
            return reuse;
        }
        return this.adjacencyCursor(node, fallbackValue);
    }

    @Override
    public AdjacencyCursor rawAdjacencyCursor() {
        return new DecompressingCursor(this.pages);
    }

    public static final class DecompressingCursor
    extends MutableIntValue
    implements AdjacencyCursor {
        private byte[][] pages;
        private final AdjacencyDecompressingReader decompress;
        private int maxTargets;
        private int currentPosition;

        private DecompressingCursor(byte[][] pages) {
            this.pages = pages;
            this.decompress = new AdjacencyDecompressingReader();
        }

        @Override
        public void init(long fromIndex, int degree) {
            this.maxTargets = this.decompress.reset(this.pages[PageUtil.pageIndex((long)fromIndex, (int)18)], PageUtil.indexInPage((long)fromIndex, (long)262143L), degree);
            this.currentPosition = 0;
        }

        @Override
        @NotNull
        public AdjacencyCursor shallowCopy(@Nullable AdjacencyCursor destination) {
            DecompressingCursor dest = destination instanceof DecompressingCursor ? (DecompressingCursor)destination : new DecompressingCursor(this.pages);
            dest.decompress.copyFrom(this.decompress);
            dest.currentPosition = this.currentPosition;
            dest.maxTargets = this.maxTargets;
            return dest;
        }

        @Override
        public int size() {
            return this.maxTargets;
        }

        @Override
        public int remaining() {
            return this.maxTargets - this.currentPosition;
        }

        @Override
        public boolean hasNextVLong() {
            return this.currentPosition < this.maxTargets;
        }

        @Override
        public long nextVLong() {
            int current = this.currentPosition++;
            int remaining = this.maxTargets - current;
            return this.decompress.next(remaining);
        }

        @Override
        public long peekVLong() {
            int remaining = this.maxTargets - this.currentPosition;
            return this.decompress.peek(remaining);
        }

        @Override
        public long skipUntil(long target) {
            long value = this.decompress.skipUntil(target, this.remaining(), this);
            this.currentPosition += this.value;
            return value;
        }

        @Override
        public long advance(long target) {
            int targetsLeftToBeDecoded = this.remaining();
            if (targetsLeftToBeDecoded <= 0) {
                return -1L;
            }
            long value = this.decompress.advance(target, targetsLeftToBeDecoded, this);
            this.currentPosition += this.value;
            return value;
        }

        @Override
        public long advanceBy(int n) {
            assert (n >= 0);
            int targetsLeftToBeDecoded = this.remaining();
            if (targetsLeftToBeDecoded <= n) {
                return -1L;
            }
            long value = this.decompress.advanceBy(n, targetsLeftToBeDecoded, this);
            this.currentPosition += this.value;
            return value;
        }

        @Override
        public void close() {
            this.pages = null;
        }
    }
}

