/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.huge.CompositeAdjacencyCursor;
import org.neo4j.gds.core.huge.NodeFilteredAdjacencyCursor;
import org.neo4j.gds.core.huge.NodeFilteredGraph;

public class CompositeAdjacencyList
implements AdjacencyList {
    private final List<AdjacencyList> adjacencyLists;
    private final CompositeAdjacencyCursorFactory compositeAdjacencyCursorFactory;
    private final AdjacencyCursorWrapperFactory adjacencyCursorWrapperFactory;

    static CompositeAdjacencyList of(List<AdjacencyList> adjacencyLists) {
        return new CompositeAdjacencyList(adjacencyLists, CompositeAdjacencyCursor::new, new AdjacencyCursorWrapperFactory.Identity());
    }

    static CompositeAdjacencyList withFilteredIdMap(List<AdjacencyList> adjacencyLists, IdMap filteredIdMap) {
        assert (filteredIdMap instanceof NodeFilteredGraph);
        AdjacencyCursorWrapperFactory adjacencyCursorWrapperFactory = cursor -> new NodeFilteredAdjacencyCursor(cursor, filteredIdMap);
        CompositeAdjacencyCursorFactory compositeAdjacencyCursorFactory = cursors -> {
            List<AdjacencyCursor> wrappedCursors = cursors.stream().map(adjacencyCursorWrapperFactory::create).collect(Collectors.toList());
            return new CompositeAdjacencyCursor(wrappedCursors);
        };
        return new CompositeAdjacencyList(adjacencyLists, compositeAdjacencyCursorFactory, adjacencyCursorWrapperFactory);
    }

    private CompositeAdjacencyList(List<AdjacencyList> adjacencyLists, CompositeAdjacencyCursorFactory compositeAdjacencyCursorFactory, AdjacencyCursorWrapperFactory adjacencyCursorWrapperFactory) {
        this.adjacencyLists = adjacencyLists;
        this.compositeAdjacencyCursorFactory = compositeAdjacencyCursorFactory;
        this.adjacencyCursorWrapperFactory = adjacencyCursorWrapperFactory;
    }

    public int size() {
        return this.adjacencyLists.size();
    }

    @Override
    public int degree(long node) {
        long degree = 0L;
        for (AdjacencyList adjacency : this.adjacencyLists) {
            degree += (long)adjacency.degree(node);
        }
        return Math.toIntExact(degree);
    }

    @Override
    public CompositeAdjacencyCursor adjacencyCursor(long node) {
        return this.adjacencyCursor(node, Double.NaN);
    }

    @Override
    public CompositeAdjacencyCursor adjacencyCursor(long node, double fallbackValue) {
        ArrayList<AdjacencyCursor> cursors = new ArrayList<AdjacencyCursor>(this.adjacencyLists.size());
        for (AdjacencyList adjacency : this.adjacencyLists) {
            cursors.add(adjacency.adjacencyCursor(node, fallbackValue));
        }
        return this.compositeAdjacencyCursorFactory.create(cursors);
    }

    @Override
    public CompositeAdjacencyCursor adjacencyCursor(@Nullable AdjacencyCursor reuse, long node) {
        return this.adjacencyCursor(reuse, node, Double.NaN);
    }

    @Override
    public CompositeAdjacencyCursor adjacencyCursor(@Nullable AdjacencyCursor reuse, long node, double fallbackValue) {
        if (reuse instanceof CompositeAdjacencyCursor) {
            CompositeAdjacencyCursor compositeReuse = (CompositeAdjacencyCursor)reuse;
            ListIterator<AdjacencyCursor> iter = compositeReuse.cursors().listIterator();
            while (iter.hasNext()) {
                int index = iter.nextIndex();
                AdjacencyCursor cursor = iter.next();
                AdjacencyCursor newCursor = this.adjacencyLists.get(index).adjacencyCursor(cursor, node, fallbackValue);
                if (newCursor == cursor) continue;
                iter.set(this.adjacencyCursorWrapperFactory.create(newCursor));
            }
            return compositeReuse;
        }
        return this.adjacencyCursor(node, fallbackValue);
    }

    @Override
    public AdjacencyCursor rawAdjacencyCursor() {
        ArrayList<AdjacencyCursor> cursors = new ArrayList<AdjacencyCursor>(this.adjacencyLists.size());
        for (AdjacencyList adjacency : this.adjacencyLists) {
            cursors.add(adjacency.rawAdjacencyCursor());
        }
        return this.compositeAdjacencyCursorFactory.create(cursors);
    }

    @Override
    public void close() {
        this.adjacencyLists.forEach(AdjacencyList::close);
    }

    @FunctionalInterface
    static interface AdjacencyCursorWrapperFactory {
        public AdjacencyCursor create(AdjacencyCursor var1);

        public static class Identity
        implements AdjacencyCursorWrapperFactory {
            @Override
            public AdjacencyCursor create(AdjacencyCursor adjacencyCursor) {
                return adjacencyCursor;
            }
        }
    }

    @FunctionalInterface
    static interface CompositeAdjacencyCursorFactory {
        public CompositeAdjacencyCursor create(List<AdjacencyCursor> var1);
    }
}

