/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.AdjacencyCursor;

public class CompositeAdjacencyCursor
implements AdjacencyCursor {
    private final PriorityQueue<AdjacencyCursor> cursorQueue;
    private final List<AdjacencyCursor> cursors;

    CompositeAdjacencyCursor(List<AdjacencyCursor> cursors) {
        this.cursors = cursors;
        this.cursorQueue = new PriorityQueue<AdjacencyCursor>(cursors.size(), Comparator.comparingLong(AdjacencyCursor::peekVLong));
        this.initializeQueue();
    }

    private void initializeQueue() {
        this.cursors.forEach(cursor -> {
            if (cursor != null && cursor.hasNextVLong()) {
                this.cursorQueue.add((AdjacencyCursor)cursor);
            }
        });
    }

    public List<AdjacencyCursor> cursors() {
        return this.cursors;
    }

    @Override
    public int size() {
        int sum = 0;
        for (AdjacencyCursor cursor : this.cursors) {
            int size = cursor.size();
            sum += size;
        }
        return sum;
    }

    @Override
    public boolean hasNextVLong() {
        return !this.cursorQueue.isEmpty();
    }

    @Override
    public long nextVLong() {
        AdjacencyCursor current = this.cursorQueue.poll();
        long targetNodeId = current.nextVLong();
        if (current.hasNextVLong()) {
            this.cursorQueue.add(current);
        }
        return targetNodeId;
    }

    @Override
    public long peekVLong() {
        return this.cursorQueue.peek().peekVLong();
    }

    @Override
    public int remaining() {
        int sum = 0;
        for (AdjacencyCursor cursor : this.cursors) {
            int remaining = cursor.remaining();
            sum += remaining;
        }
        return sum;
    }

    @Override
    public void close() {
        this.cursors.forEach(AdjacencyCursor::close);
    }

    @Override
    public long skipUntil(long target) {
        for (AdjacencyCursor cursor : this.cursors) {
            this.cursorQueue.remove(cursor);
            while (cursor.hasNextVLong() && cursor.peekVLong() <= target) {
                cursor.nextVLong();
            }
            if (!cursor.hasNextVLong()) continue;
            this.cursorQueue.add(cursor);
        }
        return this.cursorQueue.isEmpty() ? -1L : this.nextVLong();
    }

    @Override
    public long advance(long target) {
        for (AdjacencyCursor cursor : this.cursors) {
            this.cursorQueue.remove(cursor);
            while (cursor.hasNextVLong() && cursor.peekVLong() < target) {
                cursor.nextVLong();
            }
            if (!cursor.hasNextVLong()) continue;
            this.cursorQueue.add(cursor);
        }
        return this.cursorQueue.isEmpty() ? -1L : this.nextVLong();
    }

    @Override
    public long advanceBy(int n) {
        assert (n >= 0);
        while (this.hasNextVLong()) {
            long target = this.nextVLong();
            if (n-- != 0) continue;
            return target;
        }
        return -1L;
    }

    @Override
    @NotNull
    public AdjacencyCursor shallowCopy(@Nullable AdjacencyCursor destination) {
        List<AdjacencyCursor> destCursors = destination instanceof CompositeAdjacencyCursor ? ((CompositeAdjacencyCursor)destination).cursors : this.emptyList(this.cursors.size());
        ListIterator<AdjacencyCursor> destIter = destCursors.listIterator();
        for (AdjacencyCursor cursor : this.cursors) {
            destIter.set(cursor.shallowCopy(destIter.next()));
        }
        return new CompositeAdjacencyCursor(destCursors);
    }

    private List<AdjacencyCursor> emptyList(int size) {
        return Arrays.asList(new AdjacencyCursor[size]);
    }

    @Override
    public void init(long index, int degree) {
        throw new UnsupportedOperationException("CompositeAdjacencyCursor does not support init, use CompositeAdjacencyList.decompressingCursor instead.");
    }
}

