/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.PropertyCursor;

public class CSRCompositeRelationshipIterator
implements CompositeRelationshipIterator {
    public static final AdjacencyProperties[] EMPTY_PROPERTIES = new AdjacencyProperties[0];
    private final AdjacencyList adjacencyList;
    private final String[] propertyKeys;
    private final AdjacencyProperties[] properties;
    private final double[] propertyBuffer;
    private AdjacencyCursor topologyCursor;
    private final PropertyCursor[] propertyCursors;

    public CSRCompositeRelationshipIterator(AdjacencyList adjacencyList, String[] propertyKeys, AdjacencyProperties[] properties) {
        int propertyCount = propertyKeys.length;
        assert (properties.length == propertyCount);
        this.adjacencyList = adjacencyList;
        this.propertyKeys = propertyKeys;
        this.properties = properties;
        this.propertyBuffer = new double[propertyCount];
        this.topologyCursor = AdjacencyCursor.empty();
        this.propertyCursors = new PropertyCursor[propertyCount];
        for (int i = 0; i < propertyCount; ++i) {
            this.propertyCursors[i] = PropertyCursor.empty();
        }
    }

    @Override
    public int degree(long nodeId) {
        return this.adjacencyList.degree(nodeId);
    }

    @Override
    public void forEachRelationship(long nodeId, CompositeRelationshipIterator.RelationshipConsumer consumer) {
        AdjacencyCursor adjacencyCursor = this.adjacencyList.adjacencyCursor(this.topologyCursor, nodeId);
        if (!adjacencyCursor.hasNextVLong()) {
            return;
        }
        this.topologyCursor = adjacencyCursor;
        int propertyCount = this.propertyKeys.length;
        for (int propertyIdx = 0; propertyIdx < propertyCount; ++propertyIdx) {
            this.propertyCursors[propertyIdx] = this.properties[propertyIdx].propertyCursor(nodeId);
        }
        while (adjacencyCursor.hasNextVLong()) {
            long target = adjacencyCursor.nextVLong();
            for (int propertyIdx = 0; propertyIdx < propertyCount; ++propertyIdx) {
                this.propertyBuffer[propertyIdx] = Double.longBitsToDouble(this.propertyCursors[propertyIdx].nextLong());
            }
            if (consumer.consume(nodeId, target, this.propertyBuffer)) continue;
            break;
        }
    }

    @Override
    public String[] propertyKeys() {
        return this.propertyKeys;
    }

    @Override
    public CompositeRelationshipIterator concurrentCopy() {
        return new CSRCompositeRelationshipIterator(this.adjacencyList, this.propertyKeys, this.properties);
    }
}

