/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.ModifiableRelationshipCursor;
import org.neo4j.gds.api.PropertyCursor;
import org.neo4j.gds.api.RelationshipCursor;

abstract class AdjacencySpliterator
implements Spliterator<RelationshipCursor> {
    private final AdjacencyCursor adjacencyCursor;
    private final ModifiableRelationshipCursor modifiableRelationshipCursor;

    static Spliterator<RelationshipCursor> of(AdjacencyCursor adjacencyCursor, long sourceNodeId, double fallbackValue) {
        return new WithoutProperty(adjacencyCursor, sourceNodeId, fallbackValue);
    }

    static Spliterator<RelationshipCursor> of(AdjacencyCursor adjacencyCursor, PropertyCursor propertyCursor, long sourceNodeId) {
        return new WithProperty(adjacencyCursor, propertyCursor, sourceNodeId);
    }

    private AdjacencySpliterator(AdjacencyCursor adjacencyCursor, long sourceNodeId) {
        this.adjacencyCursor = adjacencyCursor;
        this.modifiableRelationshipCursor = ModifiableRelationshipCursor.create().setSourceId(sourceNodeId);
    }

    @Override
    public boolean tryAdvance(Consumer<? super RelationshipCursor> action) {
        if (this.adjacencyCursor.hasNextVLong()) {
            this.modifyCursor(this.modifiableRelationshipCursor.setTargetId(this.adjacencyCursor.nextVLong()));
            action.accept(this.modifiableRelationshipCursor);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<RelationshipCursor> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.adjacencyCursor.remaining();
    }

    @Override
    public int characteristics() {
        return 81;
    }

    abstract void modifyCursor(ModifiableRelationshipCursor var1);

    static final class WithProperty
    extends AdjacencySpliterator {
        private final PropertyCursor propertyCursor;

        WithProperty(AdjacencyCursor adjacencyCursor, PropertyCursor propertyCursor, long sourceNodeId) {
            super(adjacencyCursor, sourceNodeId);
            this.propertyCursor = propertyCursor;
        }

        @Override
        void modifyCursor(ModifiableRelationshipCursor cursor) {
            long propertyBits = this.propertyCursor.nextLong();
            double property = Double.longBitsToDouble(propertyBits);
            cursor.setProperty(property);
        }
    }

    static final class WithoutProperty
    extends AdjacencySpliterator {
        private final double fallbackValue;

        WithoutProperty(AdjacencyCursor adjacencyCursor, long sourceNodeId, double fallbackValue) {
            super(adjacencyCursor, sourceNodeId);
            this.fallbackValue = fallbackValue;
        }

        @Override
        void modifyCursor(ModifiableRelationshipCursor cursor) {
            cursor.setProperty(this.fallbackValue);
        }
    }
}

