/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.Arrays;
import org.neo4j.gds.core.huge.VarLongDecoding;
import org.neo4j.gds.core.loading.MutableIntValue;

final class AdjacencyDecompressingReader {
    static final int CHUNK_SIZE = 64;
    private final long[] block = new long[64];
    private int pos;
    private byte[] array;
    private int offset;

    AdjacencyDecompressingReader() {
    }

    static long readLong(byte[] array, int offset) {
        return (long)array[offset] & 0xFFL | ((long)array[1 + offset] & 0xFFL) << 8 | ((long)array[2 + offset] & 0xFFL) << 16 | ((long)array[3 + offset] & 0xFFL) << 24 | ((long)array[4 + offset] & 0xFFL) << 32 | ((long)array[5 + offset] & 0xFFL) << 40 | ((long)array[6 + offset] & 0xFFL) << 48 | ((long)array[7 + offset] & 0xFFL) << 56;
    }

    void copyFrom(AdjacencyDecompressingReader other) {
        System.arraycopy(other.block, 0, this.block, 0, 64);
        this.pos = other.pos;
        this.array = other.array;
        this.offset = other.offset;
    }

    int reset(byte[] adjacencyPage, int offset, int degree) {
        this.array = adjacencyPage;
        this.offset = VarLongDecoding.decodeDeltaVLongs(0L, adjacencyPage, offset, Math.min(degree, 64), this.block);
        this.pos = 0;
        return degree;
    }

    long next(int remaining) {
        int pos;
        if ((pos = this.pos++) < 64) {
            return this.block[pos];
        }
        this.pos = 1;
        return this.readNextBlock(remaining);
    }

    long peek(int remaining) {
        int pos = this.pos;
        if (pos < 64) {
            return this.block[pos];
        }
        this.pos = 0;
        return this.readNextBlock(remaining);
    }

    private long readNextBlock(int remaining) {
        this.offset = VarLongDecoding.decodeDeltaVLongs(this.block[63], this.array, this.offset, Math.min(remaining, 64), this.block);
        return this.block[0];
    }

    long skipUntil(long target, int remaining, MutableIntValue consumed) {
        int pos = this.pos;
        long[] block = this.block;
        int available = remaining;
        while (available > 64 - pos && block[63] <= target) {
            int skippedInThisBlock = 64 - pos;
            int needToDecode = Math.min(64, available -= skippedInThisBlock);
            this.offset = VarLongDecoding.decodeDeltaVLongs(block[63], this.array, this.offset, needToDecode, block);
            pos = 0;
        }
        if (available <= 0) {
            return -1L;
        }
        int targetPos = this.findPosStrictlyGreaterInBlock(target, pos, Math.min(pos + available, 64), block);
        consumed.value = remaining - (available -= 1 + targetPos - pos);
        this.pos = 1 + targetPos;
        return block[targetPos];
    }

    long advance(long target, int remaining, MutableIntValue consumed) {
        int pos = this.pos;
        long[] block = this.block;
        int available = remaining;
        while (available > 64 - pos && block[63] < target) {
            int skippedInThisBlock = 64 - pos;
            int needToDecode = Math.min(64, available -= skippedInThisBlock);
            this.offset = VarLongDecoding.decodeDeltaVLongs(block[63], this.array, this.offset, needToDecode, block);
            pos = 0;
        }
        int targetPos = this.findPosInBlock(target, pos, Math.min(pos + available, 64), block);
        consumed.value = remaining - (available -= 1 + targetPos - pos);
        this.pos = 1 + targetPos;
        return block[targetPos];
    }

    long advanceBy(int skip, int remaining, MutableIntValue consumed) {
        assert (skip < remaining) : "skip must be less than remaining but got skip=" + skip + " remaining=" + remaining;
        int availableBeyondSkip = remaining - skip;
        int initialSkip = skip;
        int pos = this.pos;
        long[] block = this.block;
        while (skip >= 64 - pos) {
            int skippedInThisBlock = 64 - pos;
            int needToDecode = Math.min(64, (skip -= skippedInThisBlock) + availableBeyondSkip);
            this.offset = VarLongDecoding.decodeDeltaVLongs(block[63], this.array, this.offset, needToDecode, block);
            pos = 0;
        }
        int targetPos = pos + skip;
        this.pos = 1 + targetPos;
        consumed.value = remaining - availableBeyondSkip - (skip -= 1 + targetPos - pos);
        assert (consumed.value == initialSkip + 1) : "Meant to skip " + initialSkip + " targets but only " + consumed.value + " were skipped";
        return block[targetPos];
    }

    private int findPosStrictlyGreaterInBlock(long target, int pos, int limit, long[] block) {
        return this.findPosInBlock(1L + target, pos, limit, block);
    }

    private int findPosInBlock(long target, int pos, int limit, long[] block) {
        int targetPos = Arrays.binarySearch(block, pos, limit, target);
        if (targetPos < 0) {
            targetPos = Math.min(-1 - targetPos, -1 + limit);
        }
        return targetPos;
    }
}

