/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.concurrency;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.concurrency.ImmutableRunWithConcurrency;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;

@ValueClass
public interface RunWithConcurrency {
    public static final long DEFAULT_MAX_NUMBER_OF_RETRIES = 250000000000L;

    public int concurrency();

    public Iterator<? extends Runnable> tasks();

    @Value.Default
    default public boolean forceUsageOfExecutor() {
        return false;
    }

    @Value.Default
    default public long waitTime() {
        return 1L;
    }

    @Value.Default
    default public TimeUnit waitTimeUnit() {
        return TimeUnit.MICROSECONDS;
    }

    @Value.Derived
    default public long waitNanos() {
        return this.waitTimeUnit().toNanos(this.waitTime());
    }

    @Value.Default
    default public long maxWaitRetries() {
        return 250000000000L;
    }

    @Value.Default
    default public TerminationFlag terminationFlag() {
        return TerminationFlag.RUNNING_TRUE;
    }

    @Value.Default
    default public boolean mayInterruptIfRunning() {
        return true;
    }

    @Value.Default
    @Nullable
    default public ExecutorService executor() {
        return Pools.DEFAULT;
    }

    default public void run() {
        ParallelUtil.runWithConcurrency(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Value.Check
    default public void validate() {
        if (this.concurrency() < 0) {
            throw new IllegalArgumentException("[concurrency] must be at least 0, but got " + this.concurrency());
        }
        if (this.waitTime() < 0L) {
            throw new IllegalArgumentException("[waitTime] must be at least 0, but got " + this.waitTime());
        }
        if (this.forceUsageOfExecutor() && !ParallelUtil.canRunInParallel(this.executor())) {
            throw new IllegalArgumentException("[executor] cannot be used to run tasks because is terminated or shut down.");
        }
    }

    public static final class Builder
    extends ImmutableRunWithConcurrency.Builder {
        public Builder tasks(Iterable<? extends Runnable> tasks) {
            return this.tasks(tasks.iterator());
        }

        public Builder tasks(Stream<? extends Runnable> tasks) {
            return this.tasks(tasks.iterator());
        }

        public Builder waitTime(long waitTime, TimeUnit waitTimeUnit) {
            return this.waitTime(waitTime).waitTimeUnit(waitTimeUnit);
        }

        public void run() {
            this.build().run();
        }
    }
}

