/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.concurrency;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.gds.concurrency.PoolSizes;
import org.neo4j.gds.concurrency.PoolSizesService;
import org.neo4j.internal.helpers.NamedThreadFactory;

public final class Pools {
    private static final String THREAD_NAME_PREFIX = "gds";
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = NamedThreadFactory.daemon((String)"gds");
    public static final ExecutorService DEFAULT = Pools.createDefaultPool();
    public static final ExecutorService DEFAULT_SINGLE_THREAD_POOL = Pools.createSingleThreadPool("algo");
    private static final ForkJoinPool.ForkJoinWorkerThreadFactory FJ_WORKER_THREAD_FACTORY = pool -> {
        ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        worker.setName("gds-forkjoin-" + worker.getPoolIndex());
        return worker;
    };

    private Pools() {
        throw new UnsupportedOperationException();
    }

    static ExecutorService createDefaultPool() {
        PoolSizes poolSizes = PoolSizesService.poolSizes();
        return new ThreadPoolExecutor(poolSizes.corePoolSize(), poolSizes.maxPoolSize(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(poolSizes.corePoolSize() * 50), DEFAULT_THREAD_FACTORY, new CallerBlocksPolicy());
    }

    public static ExecutorService createSingleThreadPool(String threadPrefix) {
        return Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.daemon((String)threadPrefix));
    }

    public static ForkJoinPool createForkJoinPool(int concurrency) {
        return new ForkJoinPool(concurrency, FJ_WORKER_THREAD_FACTORY, null, false);
    }

    public static Thread newThread(Runnable code) {
        return DEFAULT_THREAD_FACTORY.newThread(code);
    }

    static class CallerBlocksPolicy
    implements RejectedExecutionHandler {
        CallerBlocksPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            FutureTask<Object> task = new FutureTask<Object>(r, null);
            BlockingQueue<Runnable> queue = executor.getQueue();
            while (!executor.isShutdown()) {
                try {
                    if (!queue.offer(task, 250L, TimeUnit.MILLISECONDS)) continue;
                    while (!executor.isShutdown()) {
                        try {
                            task.get(250L, TimeUnit.MILLISECONDS);
                            return;
                        }
                        catch (TimeoutException timeoutException) {
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

