/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.concurrency;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.TerminationFlag;

@ParametersAreNonnullByDefault
@Generated(from="RunWithConcurrency", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRunWithConcurrency
implements RunWithConcurrency {
    private final int concurrency;
    private final Iterator<? extends Runnable> tasks;
    private final boolean forceUsageOfExecutor;
    private final long waitTime;
    private final TimeUnit waitTimeUnit;
    private final transient long waitNanos;
    private final long maxWaitRetries;
    private final TerminationFlag terminationFlag;
    private final boolean mayInterruptIfRunning;
    @Nullable
    private final ExecutorService executor;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRunWithConcurrency(int concurrency, Iterator<? extends Runnable> tasks, boolean forceUsageOfExecutor, long waitTime, TimeUnit waitTimeUnit, long maxWaitRetries, TerminationFlag terminationFlag, boolean mayInterruptIfRunning, @Nullable ExecutorService executor) {
        this.concurrency = concurrency;
        this.tasks = Objects.requireNonNull(tasks, "tasks");
        this.initShim.forceUsageOfExecutor(forceUsageOfExecutor);
        this.initShim.waitTime(waitTime);
        this.initShim.waitTimeUnit(Objects.requireNonNull(waitTimeUnit, "waitTimeUnit"));
        this.initShim.maxWaitRetries(maxWaitRetries);
        this.initShim.terminationFlag(Objects.requireNonNull(terminationFlag, "terminationFlag"));
        this.initShim.mayInterruptIfRunning(mayInterruptIfRunning);
        this.initShim.executor(executor);
        this.forceUsageOfExecutor = this.initShim.forceUsageOfExecutor();
        this.waitTime = this.initShim.waitTime();
        this.waitTimeUnit = this.initShim.waitTimeUnit();
        this.waitNanos = this.initShim.waitNanos();
        this.maxWaitRetries = this.initShim.maxWaitRetries();
        this.terminationFlag = this.initShim.terminationFlag();
        this.mayInterruptIfRunning = this.initShim.mayInterruptIfRunning();
        this.executor = this.initShim.executor();
        this.initShim = null;
    }

    private ImmutableRunWithConcurrency(Builder builder) {
        this.concurrency = builder.concurrency;
        this.tasks = builder.tasks;
        if (builder.forceUsageOfExecutorIsSet()) {
            this.initShim.forceUsageOfExecutor(builder.forceUsageOfExecutor);
        }
        if (builder.waitTimeIsSet()) {
            this.initShim.waitTime(builder.waitTime);
        }
        if (builder.waitTimeUnit != null) {
            this.initShim.waitTimeUnit(builder.waitTimeUnit);
        }
        if (builder.maxWaitRetriesIsSet()) {
            this.initShim.maxWaitRetries(builder.maxWaitRetries);
        }
        if (builder.terminationFlag != null) {
            this.initShim.terminationFlag(builder.terminationFlag);
        }
        if (builder.mayInterruptIfRunningIsSet()) {
            this.initShim.mayInterruptIfRunning(builder.mayInterruptIfRunning);
        }
        if (builder.executorIsSet()) {
            this.initShim.executor(builder.executor);
        }
        this.forceUsageOfExecutor = this.initShim.forceUsageOfExecutor();
        this.waitTime = this.initShim.waitTime();
        this.waitTimeUnit = this.initShim.waitTimeUnit();
        this.waitNanos = this.initShim.waitNanos();
        this.maxWaitRetries = this.initShim.maxWaitRetries();
        this.terminationFlag = this.initShim.terminationFlag();
        this.mayInterruptIfRunning = this.initShim.mayInterruptIfRunning();
        this.executor = this.initShim.executor();
        this.initShim = null;
    }

    private ImmutableRunWithConcurrency(ImmutableRunWithConcurrency original, int concurrency, Iterator<? extends Runnable> tasks, boolean forceUsageOfExecutor, long waitTime, TimeUnit waitTimeUnit, long maxWaitRetries, TerminationFlag terminationFlag, boolean mayInterruptIfRunning, @Nullable ExecutorService executor) {
        this.concurrency = concurrency;
        this.tasks = tasks;
        this.initShim.forceUsageOfExecutor(forceUsageOfExecutor);
        this.initShim.waitTime(waitTime);
        this.initShim.waitTimeUnit(waitTimeUnit);
        this.initShim.maxWaitRetries(maxWaitRetries);
        this.initShim.terminationFlag(terminationFlag);
        this.initShim.mayInterruptIfRunning(mayInterruptIfRunning);
        this.initShim.executor(executor);
        this.forceUsageOfExecutor = this.initShim.forceUsageOfExecutor();
        this.waitTime = this.initShim.waitTime();
        this.waitTimeUnit = this.initShim.waitTimeUnit();
        this.waitNanos = this.initShim.waitNanos();
        this.maxWaitRetries = this.initShim.maxWaitRetries();
        this.terminationFlag = this.initShim.terminationFlag();
        this.mayInterruptIfRunning = this.initShim.mayInterruptIfRunning();
        this.executor = this.initShim.executor();
        this.initShim = null;
    }

    private boolean forceUsageOfExecutorInitialize() {
        return RunWithConcurrency.super.forceUsageOfExecutor();
    }

    private long waitTimeInitialize() {
        return RunWithConcurrency.super.waitTime();
    }

    private TimeUnit waitTimeUnitInitialize() {
        return RunWithConcurrency.super.waitTimeUnit();
    }

    private long waitNanosInitialize() {
        return RunWithConcurrency.super.waitNanos();
    }

    private long maxWaitRetriesInitialize() {
        return RunWithConcurrency.super.maxWaitRetries();
    }

    private TerminationFlag terminationFlagInitialize() {
        return RunWithConcurrency.super.terminationFlag();
    }

    private boolean mayInterruptIfRunningInitialize() {
        return RunWithConcurrency.super.mayInterruptIfRunning();
    }

    @Nullable
    private ExecutorService executorInitialize() {
        return RunWithConcurrency.super.executor();
    }

    @Override
    public int concurrency() {
        return this.concurrency;
    }

    @Override
    public Iterator<? extends Runnable> tasks() {
        return this.tasks;
    }

    @Override
    public boolean forceUsageOfExecutor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forceUsageOfExecutor() : this.forceUsageOfExecutor;
    }

    @Override
    public long waitTime() {
        InitShim shim = this.initShim;
        return shim != null ? shim.waitTime() : this.waitTime;
    }

    @Override
    public TimeUnit waitTimeUnit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.waitTimeUnit() : this.waitTimeUnit;
    }

    @Override
    public long waitNanos() {
        InitShim shim = this.initShim;
        return shim != null ? shim.waitNanos() : this.waitNanos;
    }

    @Override
    public long maxWaitRetries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxWaitRetries() : this.maxWaitRetries;
    }

    @Override
    public TerminationFlag terminationFlag() {
        InitShim shim = this.initShim;
        return shim != null ? shim.terminationFlag() : this.terminationFlag;
    }

    @Override
    public boolean mayInterruptIfRunning() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mayInterruptIfRunning() : this.mayInterruptIfRunning;
    }

    @Override
    @Nullable
    public ExecutorService executor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executor() : this.executor;
    }

    public final ImmutableRunWithConcurrency withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, value, this.tasks, this.forceUsageOfExecutor, this.waitTime, this.waitTimeUnit, this.maxWaitRetries, this.terminationFlag, this.mayInterruptIfRunning, this.executor));
    }

    public final ImmutableRunWithConcurrency withTasks(Iterator<? extends Runnable> value) {
        if (this.tasks == value) {
            return this;
        }
        Iterator<? extends Runnable> newValue = Objects.requireNonNull(value, "tasks");
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, newValue, this.forceUsageOfExecutor, this.waitTime, this.waitTimeUnit, this.maxWaitRetries, this.terminationFlag, this.mayInterruptIfRunning, this.executor));
    }

    public final ImmutableRunWithConcurrency withForceUsageOfExecutor(boolean value) {
        if (this.forceUsageOfExecutor == value) {
            return this;
        }
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, this.tasks, value, this.waitTime, this.waitTimeUnit, this.maxWaitRetries, this.terminationFlag, this.mayInterruptIfRunning, this.executor));
    }

    public final ImmutableRunWithConcurrency withWaitTime(long value) {
        if (this.waitTime == value) {
            return this;
        }
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, this.tasks, this.forceUsageOfExecutor, value, this.waitTimeUnit, this.maxWaitRetries, this.terminationFlag, this.mayInterruptIfRunning, this.executor));
    }

    public final ImmutableRunWithConcurrency withWaitTimeUnit(TimeUnit value) {
        if (this.waitTimeUnit == value) {
            return this;
        }
        TimeUnit newValue = Objects.requireNonNull(value, "waitTimeUnit");
        if (this.waitTimeUnit.equals((Object)newValue)) {
            return this;
        }
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, this.tasks, this.forceUsageOfExecutor, this.waitTime, newValue, this.maxWaitRetries, this.terminationFlag, this.mayInterruptIfRunning, this.executor));
    }

    public final ImmutableRunWithConcurrency withMaxWaitRetries(long value) {
        if (this.maxWaitRetries == value) {
            return this;
        }
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, this.tasks, this.forceUsageOfExecutor, this.waitTime, this.waitTimeUnit, value, this.terminationFlag, this.mayInterruptIfRunning, this.executor));
    }

    public final ImmutableRunWithConcurrency withTerminationFlag(TerminationFlag value) {
        if (this.terminationFlag == value) {
            return this;
        }
        TerminationFlag newValue = Objects.requireNonNull(value, "terminationFlag");
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, this.tasks, this.forceUsageOfExecutor, this.waitTime, this.waitTimeUnit, this.maxWaitRetries, newValue, this.mayInterruptIfRunning, this.executor));
    }

    public final ImmutableRunWithConcurrency withMayInterruptIfRunning(boolean value) {
        if (this.mayInterruptIfRunning == value) {
            return this;
        }
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, this.tasks, this.forceUsageOfExecutor, this.waitTime, this.waitTimeUnit, this.maxWaitRetries, this.terminationFlag, value, this.executor));
    }

    public final ImmutableRunWithConcurrency withExecutor(@Nullable ExecutorService value) {
        if (this.executor == value) {
            return this;
        }
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this, this.concurrency, this.tasks, this.forceUsageOfExecutor, this.waitTime, this.waitTimeUnit, this.maxWaitRetries, this.terminationFlag, this.mayInterruptIfRunning, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRunWithConcurrency && this.equalTo((ImmutableRunWithConcurrency)another);
    }

    private boolean equalTo(ImmutableRunWithConcurrency another) {
        return this.concurrency == another.concurrency && this.tasks.equals(another.tasks) && this.forceUsageOfExecutor == another.forceUsageOfExecutor && this.waitTime == another.waitTime && this.waitTimeUnit.equals((Object)another.waitTimeUnit) && this.waitNanos == another.waitNanos && this.maxWaitRetries == another.maxWaitRetries && this.terminationFlag.equals(another.terminationFlag) && this.mayInterruptIfRunning == another.mayInterruptIfRunning && Objects.equals(this.executor, another.executor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.tasks.hashCode();
        h += (h << 5) + Boolean.hashCode(this.forceUsageOfExecutor);
        h += (h << 5) + Long.hashCode(this.waitTime);
        h += (h << 5) + this.waitTimeUnit.hashCode();
        h += (h << 5) + Long.hashCode(this.waitNanos);
        h += (h << 5) + Long.hashCode(this.maxWaitRetries);
        h += (h << 5) + this.terminationFlag.hashCode();
        h += (h << 5) + Boolean.hashCode(this.mayInterruptIfRunning);
        h += (h << 5) + Objects.hashCode(this.executor);
        return h;
    }

    public String toString() {
        return "RunWithConcurrency{concurrency=" + this.concurrency + ", tasks=" + this.tasks + ", forceUsageOfExecutor=" + this.forceUsageOfExecutor + ", waitTime=" + this.waitTime + ", waitTimeUnit=" + this.waitTimeUnit + ", waitNanos=" + this.waitNanos + ", maxWaitRetries=" + this.maxWaitRetries + ", terminationFlag=" + this.terminationFlag + ", mayInterruptIfRunning=" + this.mayInterruptIfRunning + ", executor=" + this.executor + "}";
    }

    public static RunWithConcurrency of(int concurrency, Iterator<? extends Runnable> tasks, boolean forceUsageOfExecutor, long waitTime, TimeUnit waitTimeUnit, long maxWaitRetries, TerminationFlag terminationFlag, boolean mayInterruptIfRunning, @Nullable ExecutorService executor) {
        return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(concurrency, tasks, forceUsageOfExecutor, waitTime, waitTimeUnit, maxWaitRetries, terminationFlag, mayInterruptIfRunning, executor));
    }

    private static ImmutableRunWithConcurrency validate(ImmutableRunWithConcurrency instance) {
        instance.validate();
        return instance;
    }

    public static RunWithConcurrency copyOf(RunWithConcurrency instance) {
        if (instance instanceof ImmutableRunWithConcurrency) {
            return (ImmutableRunWithConcurrency)instance;
        }
        return new RunWithConcurrency.Builder().from(instance).build();
    }

    @Generated(from="RunWithConcurrency", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_CONCURRENCY = 1L;
        private static final long INIT_BIT_TASKS = 2L;
        private static final long OPT_BIT_FORCE_USAGE_OF_EXECUTOR = 1L;
        private static final long OPT_BIT_WAIT_TIME = 2L;
        private static final long OPT_BIT_MAX_WAIT_RETRIES = 4L;
        private static final long OPT_BIT_MAY_INTERRUPT_IF_RUNNING = 8L;
        private static final long OPT_BIT_EXECUTOR = 16L;
        private long initBits = 3L;
        private long optBits;
        private int concurrency;
        @javax.annotation.Nullable
        private Iterator<? extends Runnable> tasks;
        private boolean forceUsageOfExecutor;
        private long waitTime;
        @javax.annotation.Nullable
        private TimeUnit waitTimeUnit;
        private long maxWaitRetries;
        @javax.annotation.Nullable
        private TerminationFlag terminationFlag;
        private boolean mayInterruptIfRunning;
        @javax.annotation.Nullable
        private ExecutorService executor;

        public Builder() {
            if (!(this instanceof RunWithConcurrency.Builder)) {
                throw new UnsupportedOperationException("Use: new RunWithConcurrency.Builder()");
            }
        }

        public final RunWithConcurrency.Builder from(RunWithConcurrency instance) {
            Objects.requireNonNull(instance, "instance");
            this.concurrency(instance.concurrency());
            this.tasks(instance.tasks());
            this.forceUsageOfExecutor(instance.forceUsageOfExecutor());
            this.waitTime(instance.waitTime());
            this.waitTimeUnit(instance.waitTimeUnit());
            this.maxWaitRetries(instance.maxWaitRetries());
            this.terminationFlag(instance.terminationFlag());
            this.mayInterruptIfRunning(instance.mayInterruptIfRunning());
            @Nullable ExecutorService executorValue = instance.executor();
            if (executorValue != null) {
                this.executor(executorValue);
            }
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder tasks(Iterator<? extends Runnable> tasks) {
            this.tasks = Objects.requireNonNull(tasks, "tasks");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder forceUsageOfExecutor(boolean forceUsageOfExecutor) {
            this.forceUsageOfExecutor = forceUsageOfExecutor;
            this.optBits |= 1L;
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder waitTime(long waitTime) {
            this.waitTime = waitTime;
            this.optBits |= 2L;
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder waitTimeUnit(TimeUnit waitTimeUnit) {
            this.waitTimeUnit = Objects.requireNonNull(waitTimeUnit, "waitTimeUnit");
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder maxWaitRetries(long maxWaitRetries) {
            this.maxWaitRetries = maxWaitRetries;
            this.optBits |= 4L;
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder terminationFlag(TerminationFlag terminationFlag) {
            this.terminationFlag = Objects.requireNonNull(terminationFlag, "terminationFlag");
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder mayInterruptIfRunning(boolean mayInterruptIfRunning) {
            this.mayInterruptIfRunning = mayInterruptIfRunning;
            this.optBits |= 8L;
            return (RunWithConcurrency.Builder)this;
        }

        public final RunWithConcurrency.Builder executor(@Nullable ExecutorService executor) {
            this.executor = executor;
            this.optBits |= 0x10L;
            return (RunWithConcurrency.Builder)this;
        }

        public RunWithConcurrency.Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.concurrency = 0;
            this.tasks = null;
            this.forceUsageOfExecutor = false;
            this.waitTime = 0L;
            this.waitTimeUnit = null;
            this.maxWaitRetries = 0L;
            this.terminationFlag = null;
            this.mayInterruptIfRunning = false;
            this.executor = null;
            return (RunWithConcurrency.Builder)this;
        }

        public RunWithConcurrency build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableRunWithConcurrency.validate(new ImmutableRunWithConcurrency(this));
        }

        private boolean forceUsageOfExecutorIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean waitTimeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean maxWaitRetriesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean mayInterruptIfRunningIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean executorIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("concurrency");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tasks");
            }
            return "Cannot build RunWithConcurrency, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RunWithConcurrency", generator="Immutables")
    private final class InitShim {
        private byte forceUsageOfExecutorBuildStage = 0;
        private boolean forceUsageOfExecutor;
        private byte waitTimeBuildStage = 0;
        private long waitTime;
        private byte waitTimeUnitBuildStage = 0;
        private TimeUnit waitTimeUnit;
        private byte waitNanosBuildStage = 0;
        private long waitNanos;
        private byte maxWaitRetriesBuildStage = 0;
        private long maxWaitRetries;
        private byte terminationFlagBuildStage = 0;
        private TerminationFlag terminationFlag;
        private byte mayInterruptIfRunningBuildStage = 0;
        private boolean mayInterruptIfRunning;
        private byte executorBuildStage = 0;
        private ExecutorService executor;

        private InitShim() {
        }

        boolean forceUsageOfExecutor() {
            if (this.forceUsageOfExecutorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forceUsageOfExecutorBuildStage == 0) {
                this.forceUsageOfExecutorBuildStage = (byte)-1;
                this.forceUsageOfExecutor = ImmutableRunWithConcurrency.this.forceUsageOfExecutorInitialize();
                this.forceUsageOfExecutorBuildStage = 1;
            }
            return this.forceUsageOfExecutor;
        }

        void forceUsageOfExecutor(boolean forceUsageOfExecutor) {
            this.forceUsageOfExecutor = forceUsageOfExecutor;
            this.forceUsageOfExecutorBuildStage = 1;
        }

        long waitTime() {
            if (this.waitTimeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.waitTimeBuildStage == 0) {
                this.waitTimeBuildStage = (byte)-1;
                this.waitTime = ImmutableRunWithConcurrency.this.waitTimeInitialize();
                this.waitTimeBuildStage = 1;
            }
            return this.waitTime;
        }

        void waitTime(long waitTime) {
            this.waitTime = waitTime;
            this.waitTimeBuildStage = 1;
        }

        TimeUnit waitTimeUnit() {
            if (this.waitTimeUnitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.waitTimeUnitBuildStage == 0) {
                this.waitTimeUnitBuildStage = (byte)-1;
                this.waitTimeUnit = Objects.requireNonNull(ImmutableRunWithConcurrency.this.waitTimeUnitInitialize(), "waitTimeUnit");
                this.waitTimeUnitBuildStage = 1;
            }
            return this.waitTimeUnit;
        }

        void waitTimeUnit(TimeUnit waitTimeUnit) {
            this.waitTimeUnit = waitTimeUnit;
            this.waitTimeUnitBuildStage = 1;
        }

        long waitNanos() {
            if (this.waitNanosBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.waitNanosBuildStage == 0) {
                this.waitNanosBuildStage = (byte)-1;
                this.waitNanos = ImmutableRunWithConcurrency.this.waitNanosInitialize();
                this.waitNanosBuildStage = 1;
            }
            return this.waitNanos;
        }

        long maxWaitRetries() {
            if (this.maxWaitRetriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxWaitRetriesBuildStage == 0) {
                this.maxWaitRetriesBuildStage = (byte)-1;
                this.maxWaitRetries = ImmutableRunWithConcurrency.this.maxWaitRetriesInitialize();
                this.maxWaitRetriesBuildStage = 1;
            }
            return this.maxWaitRetries;
        }

        void maxWaitRetries(long maxWaitRetries) {
            this.maxWaitRetries = maxWaitRetries;
            this.maxWaitRetriesBuildStage = 1;
        }

        TerminationFlag terminationFlag() {
            if (this.terminationFlagBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.terminationFlagBuildStage == 0) {
                this.terminationFlagBuildStage = (byte)-1;
                this.terminationFlag = Objects.requireNonNull(ImmutableRunWithConcurrency.this.terminationFlagInitialize(), "terminationFlag");
                this.terminationFlagBuildStage = 1;
            }
            return this.terminationFlag;
        }

        void terminationFlag(TerminationFlag terminationFlag) {
            this.terminationFlag = terminationFlag;
            this.terminationFlagBuildStage = 1;
        }

        boolean mayInterruptIfRunning() {
            if (this.mayInterruptIfRunningBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mayInterruptIfRunningBuildStage == 0) {
                this.mayInterruptIfRunningBuildStage = (byte)-1;
                this.mayInterruptIfRunning = ImmutableRunWithConcurrency.this.mayInterruptIfRunningInitialize();
                this.mayInterruptIfRunningBuildStage = 1;
            }
            return this.mayInterruptIfRunning;
        }

        void mayInterruptIfRunning(boolean mayInterruptIfRunning) {
            this.mayInterruptIfRunning = mayInterruptIfRunning;
            this.mayInterruptIfRunningBuildStage = 1;
        }

        ExecutorService executor() {
            if (this.executorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executorBuildStage == 0) {
                this.executorBuildStage = (byte)-1;
                this.executor = ImmutableRunWithConcurrency.this.executorInitialize();
                this.executorBuildStage = 1;
            }
            return this.executor;
        }

        void executor(ExecutorService executor) {
            this.executor = executor;
            this.executorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.forceUsageOfExecutorBuildStage == -1) {
                attributes.add("forceUsageOfExecutor");
            }
            if (this.waitTimeBuildStage == -1) {
                attributes.add("waitTime");
            }
            if (this.waitTimeUnitBuildStage == -1) {
                attributes.add("waitTimeUnit");
            }
            if (this.waitNanosBuildStage == -1) {
                attributes.add("waitNanos");
            }
            if (this.maxWaitRetriesBuildStage == -1) {
                attributes.add("maxWaitRetries");
            }
            if (this.terminationFlagBuildStage == -1) {
                attributes.add("terminationFlag");
            }
            if (this.mayInterruptIfRunningBuildStage == -1) {
                attributes.add("mayInterruptIfRunning");
            }
            if (this.executorBuildStage == -1) {
                attributes.add("executor");
            }
            return "Cannot build RunWithConcurrency, attribute initializers form cycle " + attributes;
        }
    }
}

