/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.concurrency;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.DoubleUnaryOperator;

public final class AtomicDouble
extends Number {
    private static final VarHandle VALUE;
    private volatile double value;

    public AtomicDouble() {
    }

    public AtomicDouble(double initialValue) {
        VALUE.set(this, initialValue);
    }

    public double get() {
        return VALUE.getVolatile(this);
    }

    public void set(double newValue) {
        VALUE.setVolatile(this, newValue);
    }

    public void lazySet(long newValue) {
        VALUE.setRelease(this, newValue);
    }

    public double getAndSet(double newValue) {
        return VALUE.getAndSet(this, newValue);
    }

    public double getAndAdd(double delta) {
        return VALUE.getAndAdd(this, delta);
    }

    public double addAndGet(double delta) {
        return VALUE.getAndAdd(this, delta) + delta;
    }

    public double getAndUpdate(DoubleUnaryOperator updateFunction) {
        double next;
        double current;
        while (!this.weakCompareAndSetVolatile(current = this.get(), next = updateFunction.applyAsDouble(current))) {
        }
        return current;
    }

    public double updateAndGet(DoubleUnaryOperator updateFunction) {
        double next;
        double current;
        while (!this.weakCompareAndSetVolatile(current = this.get(), next = updateFunction.applyAsDouble(current))) {
        }
        return next;
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    public double getPlain() {
        return VALUE.get(this);
    }

    public void setPlain(double newValue) {
        VALUE.set(this, newValue);
    }

    public double getOpaque() {
        return VALUE.getOpaque(this);
    }

    public void setOpaque(double newValue) {
        VALUE.setOpaque(this, newValue);
    }

    public double getAcquire() {
        return VALUE.getAcquire(this);
    }

    public void setRelease(double newValue) {
        VALUE.setRelease(this, newValue);
    }

    public boolean compareAndSet(double expectedValue, double newValue) {
        return VALUE.compareAndSet(this, expectedValue, newValue);
    }

    public double compareAndExchange(double expectedValue, double newValue) {
        return VALUE.compareAndExchange(this, expectedValue, newValue);
    }

    public double compareAndExchangeAcquire(double expectedValue, double newValue) {
        return VALUE.compareAndExchangeAcquire(this, expectedValue, newValue);
    }

    public double compareAndExchangeRelease(double expectedValue, double newValue) {
        return VALUE.compareAndExchangeRelease(this, expectedValue, newValue);
    }

    public boolean weakCompareAndSetPlain(double expectedValue, double newValue) {
        return VALUE.weakCompareAndSetPlain(this, expectedValue, newValue);
    }

    public boolean weakCompareAndSetVolatile(double expectedValue, double newValue) {
        return VALUE.weakCompareAndSet(this, expectedValue, newValue);
    }

    public boolean weakCompareAndSetAcquire(double expectedValue, double newValue) {
        return VALUE.weakCompareAndSetAcquire(this, expectedValue, newValue);
    }

    public boolean weakCompareAndSetRelease(double expectedValue, double newValue) {
        return VALUE.weakCompareAndSetRelease(this, expectedValue, newValue);
    }

    public String toString() {
        return Double.toString(this.get());
    }

    static {
        try {
            VALUE = MethodHandles.lookup().findVarHandle(AtomicDouble.class, "value", Double.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

