/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.compress;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.core.compress.AdjacencyListsWithProperties;

@ParametersAreNonnullByDefault
@Generated(from="AdjacencyListsWithProperties", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableAdjacencyListsWithProperties
implements AdjacencyListsWithProperties {
    private final AdjacencyList adjacency;
    private final long relationshipCount;
    private final List<AdjacencyProperties> properties;

    private ImmutableAdjacencyListsWithProperties(AdjacencyList adjacency, long relationshipCount, Iterable<? extends AdjacencyProperties> properties) {
        this.adjacency = Objects.requireNonNull(adjacency, "adjacency");
        this.relationshipCount = relationshipCount;
        this.properties = ImmutableAdjacencyListsWithProperties.createUnmodifiableList(false, ImmutableAdjacencyListsWithProperties.createSafeList(properties, true, false));
    }

    private ImmutableAdjacencyListsWithProperties(ImmutableAdjacencyListsWithProperties original, AdjacencyList adjacency, long relationshipCount, List<AdjacencyProperties> properties) {
        this.adjacency = adjacency;
        this.relationshipCount = relationshipCount;
        this.properties = properties;
    }

    @Override
    public AdjacencyList adjacency() {
        return this.adjacency;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public List<AdjacencyProperties> properties() {
        return this.properties;
    }

    public final ImmutableAdjacencyListsWithProperties withAdjacency(AdjacencyList value) {
        if (this.adjacency == value) {
            return this;
        }
        AdjacencyList newValue = Objects.requireNonNull(value, "adjacency");
        return new ImmutableAdjacencyListsWithProperties(this, newValue, this.relationshipCount, this.properties);
    }

    public final ImmutableAdjacencyListsWithProperties withRelationshipCount(long value) {
        if (this.relationshipCount == value) {
            return this;
        }
        return new ImmutableAdjacencyListsWithProperties(this, this.adjacency, value, this.properties);
    }

    public final ImmutableAdjacencyListsWithProperties withProperties(AdjacencyProperties ... elements) {
        List<AdjacencyProperties> newValue = ImmutableAdjacencyListsWithProperties.createUnmodifiableList(false, ImmutableAdjacencyListsWithProperties.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAdjacencyListsWithProperties(this, this.adjacency, this.relationshipCount, newValue);
    }

    public final ImmutableAdjacencyListsWithProperties withProperties(Iterable<? extends AdjacencyProperties> elements) {
        if (this.properties == elements) {
            return this;
        }
        List<AdjacencyProperties> newValue = ImmutableAdjacencyListsWithProperties.createUnmodifiableList(false, ImmutableAdjacencyListsWithProperties.createSafeList(elements, true, false));
        return new ImmutableAdjacencyListsWithProperties(this, this.adjacency, this.relationshipCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdjacencyListsWithProperties && this.equalTo((ImmutableAdjacencyListsWithProperties)another);
    }

    private boolean equalTo(ImmutableAdjacencyListsWithProperties another) {
        return this.adjacency.equals(another.adjacency) && this.relationshipCount == another.relationshipCount && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.adjacency.hashCode();
        h += (h << 5) + Long.hashCode(this.relationshipCount);
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "AdjacencyListsWithProperties{adjacency=" + this.adjacency + ", relationshipCount=" + this.relationshipCount + ", properties=" + this.properties + "}";
    }

    public static AdjacencyListsWithProperties of(AdjacencyList adjacency, long relationshipCount, List<AdjacencyProperties> properties) {
        return ImmutableAdjacencyListsWithProperties.of(adjacency, relationshipCount, properties);
    }

    public static AdjacencyListsWithProperties of(AdjacencyList adjacency, long relationshipCount, Iterable<? extends AdjacencyProperties> properties) {
        return new ImmutableAdjacencyListsWithProperties(adjacency, relationshipCount, properties);
    }

    public static AdjacencyListsWithProperties copyOf(AdjacencyListsWithProperties instance) {
        if (instance instanceof ImmutableAdjacencyListsWithProperties) {
            return (ImmutableAdjacencyListsWithProperties)instance;
        }
        return ImmutableAdjacencyListsWithProperties.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AdjacencyListsWithProperties", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ADJACENCY = 1L;
        private static final long INIT_BIT_RELATIONSHIP_COUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private AdjacencyList adjacency;
        private long relationshipCount;
        private List<AdjacencyProperties> properties = null;

        private Builder() {
        }

        public final Builder from(AdjacencyListsWithProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.adjacency(instance.adjacency());
            this.relationshipCount(instance.relationshipCount());
            this.addAllProperties(instance.properties());
            return this;
        }

        public final Builder adjacency(AdjacencyList adjacency) {
            this.adjacency = Objects.requireNonNull(adjacency, "adjacency");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipCount(long relationshipCount) {
            this.relationshipCount = relationshipCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addProperty(AdjacencyProperties element) {
            if (this.properties == null) {
                this.properties = new ArrayList<AdjacencyProperties>();
            }
            this.properties.add(Objects.requireNonNull(element, "properties element"));
            return this;
        }

        public final Builder addProperties(AdjacencyProperties ... elements) {
            if (this.properties == null) {
                this.properties = new ArrayList<AdjacencyProperties>();
            }
            for (AdjacencyProperties element : elements) {
                this.properties.add(Objects.requireNonNull(element, "properties element"));
            }
            return this;
        }

        public final Builder properties(Iterable<? extends AdjacencyProperties> elements) {
            this.properties = new ArrayList<AdjacencyProperties>();
            return this.addAllProperties(elements);
        }

        public final Builder addAllProperties(Iterable<? extends AdjacencyProperties> elements) {
            Objects.requireNonNull(elements, "properties element");
            if (this.properties == null) {
                this.properties = new ArrayList<AdjacencyProperties>();
            }
            for (AdjacencyProperties adjacencyProperties : elements) {
                this.properties.add(Objects.requireNonNull(adjacencyProperties, "properties element"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.adjacency = null;
            this.relationshipCount = 0L;
            if (this.properties != null) {
                this.properties.clear();
            }
            return this;
        }

        public AdjacencyListsWithProperties build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAdjacencyListsWithProperties(null, this.adjacency, this.relationshipCount, this.properties == null ? Collections.emptyList() : ImmutableAdjacencyListsWithProperties.createUnmodifiableList(true, this.properties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("adjacency");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipCount");
            }
            return "Cannot build AdjacencyListsWithProperties, some of required attributes are not set " + attributes;
        }
    }
}

