/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.compress;

import java.util.Arrays;
import java.util.function.LongSupplier;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.huge.CompressedAdjacencyList;
import org.neo4j.gds.core.huge.UncompressedAdjacencyList;
import org.neo4j.gds.core.loading.CompressedAdjacencyListBuilderFactory;
import org.neo4j.gds.core.loading.DeltaVarLongCompressor;
import org.neo4j.gds.core.loading.RawCompressor;
import org.neo4j.gds.core.loading.UncompressedAdjacencyListBuilderFactory;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.utils.GdsFeatureToggles;

public interface AdjacencyListBehavior {
    public static AdjacencyCompressorFactory asConfigured(LongSupplier nodeCountSupplier, PropertyMappings propertyMappings, Aggregation[] aggregations) {
        Aggregation[] resolvedAggregations = (Aggregation[])Arrays.stream(aggregations).map(Aggregation::resolve).toArray(Aggregation[]::new);
        boolean noAggregation = Arrays.stream(aggregations).map(Aggregation::resolve).allMatch(Aggregation::equivalentToNone);
        return GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.isEnabled() ? AdjacencyListBehavior.uncompressed(nodeCountSupplier, propertyMappings, resolvedAggregations, noAggregation) : AdjacencyListBehavior.compressed(nodeCountSupplier, propertyMappings, resolvedAggregations, noAggregation);
    }

    public static AdjacencyCompressorFactory compressed(LongSupplier nodeCountSupplier, PropertyMappings propertyMappings, Aggregation[] aggregations, boolean noAggregation) {
        return DeltaVarLongCompressor.factory(nodeCountSupplier, CompressedAdjacencyListBuilderFactory.of(), propertyMappings, aggregations, noAggregation);
    }

    public static AdjacencyCompressorFactory uncompressed(LongSupplier nodeCountSupplier, PropertyMappings propertyMappings, Aggregation[] aggregations, boolean noAggregation) {
        return RawCompressor.factory(nodeCountSupplier, UncompressedAdjacencyListBuilderFactory.of(), propertyMappings, aggregations, noAggregation);
    }

    public static MemoryEstimation adjacencyListEstimation(long avgDegree, long nodeCount) {
        return GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.isEnabled() ? UncompressedAdjacencyList.adjacencyListEstimation(avgDegree, nodeCount) : CompressedAdjacencyList.adjacencyListEstimation(avgDegree, nodeCount);
    }

    public static MemoryEstimation adjacencyListEstimation(RelationshipType relationshipType, boolean undirected) {
        return GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.isEnabled() ? UncompressedAdjacencyList.adjacencyListEstimation(relationshipType, undirected) : CompressedAdjacencyList.adjacencyListEstimation(relationshipType, undirected);
    }

    public static MemoryEstimation adjacencyPropertiesEstimation(RelationshipType relationshipType, boolean undirected) {
        return UncompressedAdjacencyList.adjacencyPropertiesEstimation(relationshipType, undirected);
    }
}

