/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.nio.file.Path;
import java.time.ZoneId;
import java.util.List;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.SettingsUtil;
import org.neo4j.graphdb.config.Setting;

public final class Settings {
    public static Setting<Boolean> authEnabled() {
        return GraphDatabaseSettings.auth_enabled;
    }

    public static String defaultDatabaseName() {
        return "neo4j";
    }

    public static Setting<Boolean> boltEnabled() {
        return BoltConnector.enabled;
    }

    public static Setting<SocketAddress> boltListenAddress() {
        return BoltConnector.listen_address;
    }

    public static Setting<Boolean> httpEnabled() {
        return HttpConnector.enabled;
    }

    public static Setting<Boolean> httpsEnabled() {
        return HttpsConnector.enabled;
    }

    public static Setting<ZoneId> dbTemporalTimezone() {
        return GraphDatabaseSettings.db_temporal_timezone;
    }

    public static Setting<Path> neo4jHome() {
        return GraphDatabaseSettings.neo4j_home;
    }

    public static <T> Setting<T> pageCacheMemory() {
        return Neo4jProxy.pageCacheMemory();
    }

    public static <T> T pageCacheMemoryValue(String value) {
        return (T)Neo4jProxy.pageCacheMemoryValue((String)value);
    }

    public static Setting<GraphDatabaseSettings.TransactionStateMemoryAllocation> transactionStateAllocation() {
        return GraphDatabaseSettings.tx_state_memory_allocation;
    }

    public static Setting<Long> transactionStateMaxOffHeapMemory() {
        return GraphDatabaseSettings.tx_state_max_off_heap_memory;
    }

    public static Setting<Path> storeInternalLogPath() {
        return GraphDatabaseSettings.store_internal_log_path;
    }

    public static <T> T disableOnlineBackup(T builder, SettingsUtil.SetConfig<T, Boolean> setConfig) {
        return (T)SettingsUtil.tryConfigure(builder, setConfig, (String)"com.neo4j.configuration.OnlineBackupSettings", (String)"online_backup_enabled", (Object)Boolean.FALSE);
    }

    public static <T> T disableReplication(T builder, SettingsUtil.SetConfig<T, Boolean> setConfig) {
        builder = SettingsUtil.tryConfigure(builder, setConfig, (String)"com.neo4j.configuration.EnterpriseEditionInternalSettings", (String)"enable_replication", (Object)Boolean.FALSE);
        builder = SettingsUtil.tryConfigure(builder, setConfig, (String)"com.neo4j.configuration.EnterpriseEditionInternalSettings", (String)"replication_enabled", (Object)Boolean.FALSE);
        return builder;
    }

    public static Setting<List<String>> procedureUnrestricted() {
        return GraphDatabaseSettings.procedure_unrestricted;
    }

    public static Setting<Boolean> failOnMissingFiles() {
        return GraphDatabaseSettings.fail_on_missing_files;
    }

    public static Setting<String> additionalJvm() {
        return Neo4jProxy.additionalJvm();
    }

    public static Setting<Path> loadCsvFileUrlRoot() {
        return GraphDatabaseSettings.load_csv_file_url_root;
    }

    public static Setting<Long> memoryTransactionMaxSize() {
        return GraphDatabaseSettings.memory_transaction_max_size;
    }

    private Settings() {
        throw new UnsupportedOperationException();
    }

    @ValueClass
    public static interface PageCacheMemorySetting<T> {
        public Setting<T> setting();

        public T value();
    }
}

