/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphLoader;

@ParametersAreNonnullByDefault
@Generated(from="GraphLoader", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphLoader
implements GraphLoader {
    private final GraphLoaderContext context;
    private final String username;
    private final GraphProjectConfig projectConfig;

    private ImmutableGraphLoader(GraphLoaderContext context, String username, GraphProjectConfig projectConfig) {
        this.context = Objects.requireNonNull(context, "context");
        this.username = Objects.requireNonNull(username, "username");
        this.projectConfig = Objects.requireNonNull(projectConfig, "projectConfig");
    }

    private ImmutableGraphLoader(Builder builder) {
        this.context = builder.context;
        this.projectConfig = builder.projectConfig;
        this.username = builder.username != null ? builder.username : Objects.requireNonNull(GraphLoader.super.username(), "username");
    }

    private ImmutableGraphLoader(ImmutableGraphLoader original, GraphLoaderContext context, String username, GraphProjectConfig projectConfig) {
        this.context = context;
        this.username = username;
        this.projectConfig = projectConfig;
    }

    @Override
    public GraphLoaderContext context() {
        return this.context;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public GraphProjectConfig projectConfig() {
        return this.projectConfig;
    }

    public final ImmutableGraphLoader withContext(GraphLoaderContext value) {
        if (this.context == value) {
            return this;
        }
        GraphLoaderContext newValue = Objects.requireNonNull(value, "context");
        return new ImmutableGraphLoader(this, newValue, this.username, this.projectConfig);
    }

    public final ImmutableGraphLoader withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableGraphLoader(this, this.context, newValue, this.projectConfig);
    }

    public final ImmutableGraphLoader withProjectConfig(GraphProjectConfig value) {
        if (this.projectConfig == value) {
            return this;
        }
        GraphProjectConfig newValue = Objects.requireNonNull(value, "projectConfig");
        return new ImmutableGraphLoader(this, this.context, this.username, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphLoader && this.equalTo((ImmutableGraphLoader)another);
    }

    private boolean equalTo(ImmutableGraphLoader another) {
        return this.context.equals(another.context) && this.username.equals(another.username) && this.projectConfig.equals(another.projectConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.projectConfig.hashCode();
        return h;
    }

    public String toString() {
        return "GraphLoader{context=" + this.context + ", username=" + this.username + ", projectConfig=" + this.projectConfig + "}";
    }

    public static GraphLoader of(GraphLoaderContext context, String username, GraphProjectConfig projectConfig) {
        return new ImmutableGraphLoader(context, username, projectConfig);
    }

    public static GraphLoader copyOf(GraphLoader instance) {
        if (instance instanceof ImmutableGraphLoader) {
            return (ImmutableGraphLoader)instance;
        }
        return ImmutableGraphLoader.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphLoader", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTEXT = 1L;
        private static final long INIT_BIT_PROJECT_CONFIG = 2L;
        private long initBits = 3L;
        @Nullable
        private GraphLoaderContext context;
        @Nullable
        private String username;
        @Nullable
        private GraphProjectConfig projectConfig;

        private Builder() {
        }

        public final Builder from(GraphLoader instance) {
            Objects.requireNonNull(instance, "instance");
            this.context(instance.context());
            this.username(instance.username());
            this.projectConfig(instance.projectConfig());
            return this;
        }

        public final Builder context(GraphLoaderContext context) {
            this.context = Objects.requireNonNull(context, "context");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder projectConfig(GraphProjectConfig projectConfig) {
            this.projectConfig = Objects.requireNonNull(projectConfig, "projectConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.context = null;
            this.username = null;
            this.projectConfig = null;
            return this;
        }

        public GraphLoader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphLoader(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("context");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectConfig");
            }
            return "Cannot build GraphLoader, some of required attributes are not set " + attributes;
        }
    }
}

