/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.GraphProjectConfig;

@ValueClass
public interface GraphLoader {
    public GraphLoaderContext context();

    @Value.Default
    default public String username() {
        return this.projectConfig().username();
    }

    public GraphProjectConfig projectConfig();

    default public Graph graph() {
        return this.graphStore().getUnion();
    }

    default public GraphStore graphStore() {
        return this.graphStoreFactory().build();
    }

    default public GraphStoreFactory<? extends GraphStore, ? extends GraphProjectConfig> graphStoreFactory() {
        return this.projectConfig().graphStoreFactory().get(this.context());
    }
}

