/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.utils.StringFormatting;

public final class GraphDimensionsValidation {
    private GraphDimensionsValidation() {
    }

    public static void validate(GraphDimensions dimensions, GraphProjectFromStoreConfig config) {
        GraphDimensionsValidation.checkValidNodePredicate(dimensions, config);
        GraphDimensionsValidation.checkValidPropertyTokens("Node", dimensions.nodePropertyTokens());
        GraphDimensionsValidation.checkValidRelationshipTypePredicate(dimensions, config);
        GraphDimensionsValidation.checkValidPropertyTokens("Relationship", dimensions.relationshipPropertyTokens());
    }

    private static void checkValidNodePredicate(GraphDimensions dimensions, GraphProjectFromStoreConfig config) {
        if (!config.nodeProjections().isEmpty() && dimensions.nodeLabelTokens().contains(-2L)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid node projection, one or more labels not found: '%s'", (Object[])new Object[]{config.nodeProjections().labelProjection()}));
        }
    }

    private static void checkValidRelationshipTypePredicate(GraphDimensions dimensions, GraphProjectFromStoreConfig config) {
        if (!config.relationshipProjections().isEmpty() && dimensions.relationshipTypeTokens().contains(-2L)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid relationship projection, one or more relationship types not found: '%s'", (Object[])new Object[]{config.relationshipProjections().typeFilter()}));
        }
    }

    private static void checkValidPropertyTokens(String recordType, Map<String, Integer> propertyIds) {
        String missingProperties = propertyIds.entrySet().stream().filter(mapping -> {
            String propertyKey = (String)mapping.getKey();
            int id = (Integer)mapping.getValue();
            return StringUtils.isNotEmpty((CharSequence)propertyKey) && id == -1 && !propertyKey.equals("*");
        }).map(Map.Entry::getKey).collect(Collectors.joining("', '"));
        if (!missingProperties.isEmpty()) {
            Object errorMessage = StringFormatting.formatWithLocale((String)"%s properties not found: '%s'", (Object[])new Object[]{recordType, missingProperties});
            errorMessage = (String)errorMessage + (recordType.equals("Relationship") ? " (if you meant to count parallel relationships, use `property:'*'`)." : "");
            throw new IllegalArgumentException((String)errorMessage);
        }
    }
}

