/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensionsReader;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.TokenRead;

public class GraphDimensionsStoreReader
extends GraphDimensionsReader<GraphProjectFromStoreConfig> {
    public GraphDimensionsStoreReader(TransactionContext tx, GraphProjectFromStoreConfig config, IdGeneratorFactory idGeneratorFactory) {
        super(tx, config, idGeneratorFactory);
    }

    @Override
    protected GraphDimensionsReader.TokenElementIdentifierMappings<NodeLabel> getNodeLabelTokens(TokenRead tokenRead) {
        GraphDimensionsReader.TokenElementIdentifierMappings<NodeLabel> labelTokenNodeLabelMappings = new GraphDimensionsReader.TokenElementIdentifierMappings<NodeLabel>(-1);
        ((GraphProjectFromStoreConfig)this.graphProjectConfig).nodeProjections().projections().forEach((nodeLabel, projection) -> {
            int labelToken = projection.projectAll() ? -1 : this.getNodeLabelToken(tokenRead, projection.label());
            labelTokenNodeLabelMappings.put(labelToken, (NodeLabel)nodeLabel);
        });
        return labelTokenNodeLabelMappings;
    }

    @Override
    protected GraphDimensionsReader.TokenElementIdentifierMappings<RelationshipType> getRelationshipTypeTokens(TokenRead tokenRead) {
        GraphDimensionsReader.TokenElementIdentifierMappings<RelationshipType> typeTokenRelTypeMappings = new GraphDimensionsReader.TokenElementIdentifierMappings<RelationshipType>(-1);
        ((GraphProjectFromStoreConfig)this.graphProjectConfig).relationshipProjections().projections().forEach((relType, projection) -> {
            int typeToken = projection.projectAll() ? -1 : this.getRelationshipTypeToken(tokenRead, projection.type());
            typeTokenRelTypeMappings.put(typeToken, (RelationshipType)relType);
        });
        return typeTokenRelTypeMappings;
    }

    @Override
    protected NodeProjections getNodeProjections() {
        return ((GraphProjectFromStoreConfig)this.graphProjectConfig).nodeProjections();
    }

    @Override
    protected RelationshipProjections getRelationshipProjections() {
        return ((GraphProjectFromStoreConfig)this.graphProjectConfig).relationshipProjections();
    }

    private int getNodeLabelToken(TokenRead tokenRead, String nodeLabel) {
        int labelToken = tokenRead.nodeLabel(nodeLabel);
        return labelToken == -1 ? -2 : labelToken;
    }

    private int getRelationshipTypeToken(TokenRead tokenRead, String relationshipType) {
        int relationshipToken = tokenRead.relationshipType(relationshipType);
        return relationshipToken == -1 ? -2 : relationshipToken;
    }
}

