/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.utils.StatementFunction;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;

public abstract class GraphDimensionsReader<T extends GraphProjectConfig>
extends StatementFunction<GraphDimensions> {
    private final IdGeneratorFactory idGeneratorFactory;
    protected T graphProjectConfig;

    GraphDimensionsReader(TransactionContext tx, T graphProjectConfig, IdGeneratorFactory idGeneratorFactory) {
        super(tx);
        this.graphProjectConfig = graphProjectConfig;
        this.idGeneratorFactory = idGeneratorFactory;
    }

    @Override
    public GraphDimensions apply(KernelTransaction transaction) throws RuntimeException {
        TokenRead tokenRead = transaction.tokenRead();
        Read dataRead = transaction.dataRead();
        TokenElementIdentifierMappings<NodeLabel> labelTokenNodeLabelMappings = this.getNodeLabelTokens(tokenRead);
        TokenElementIdentifierMappings<RelationshipType> typeTokenRelTypeMappings = this.getRelationshipTypeTokens(tokenRead);
        Map<String, Integer> nodePropertyTokens = this.loadPropertyTokens(this.getNodeProjections().projections(), tokenRead);
        Map<String, Integer> relationshipPropertyTokens = this.loadPropertyTokens(this.getRelationshipProjections().projections(), tokenRead);
        long nodeCount = labelTokenNodeLabelMappings.keyStream().mapToLong(arg_0 -> ((Read)dataRead).countsForNode(arg_0)).sum();
        long allNodesCount = Neo4jProxy.getHighestPossibleNodeCount((Read)dataRead, (IdGeneratorFactory)this.idGeneratorFactory);
        long finalNodeCount = labelTokenNodeLabelMappings.keys().contains(-1L) ? allNodesCount : Math.min(nodeCount, allNodesCount);
        Map<RelationshipType, Long> relationshipCounts = this.getRelationshipCountsByType(dataRead, labelTokenNodeLabelMappings, typeTokenRelTypeMappings);
        long relCountUpperBound = relationshipCounts.values().stream().mapToLong(Long::longValue).sum();
        long allRelationshipsCount = Neo4jProxy.getHighestPossibleRelationshipCount((Read)dataRead, (IdGeneratorFactory)this.idGeneratorFactory);
        return ImmutableGraphDimensions.builder().nodeCount(finalNodeCount).highestPossibleNodeCount(allNodesCount).relCountUpperBound(relCountUpperBound).relationshipCounts(relationshipCounts).highestRelationshipId(allRelationshipsCount).nodeLabelTokens(labelTokenNodeLabelMappings.keys()).relationshipTypeTokens(typeTokenRelTypeMappings.keys()).tokenNodeLabelMapping(labelTokenNodeLabelMappings.mappings()).tokenRelationshipTypeMapping(typeTokenRelTypeMappings.mappings()).nodePropertyTokens(nodePropertyTokens).relationshipPropertyTokens(relationshipPropertyTokens).build();
    }

    protected abstract TokenElementIdentifierMappings<NodeLabel> getNodeLabelTokens(TokenRead var1);

    protected abstract TokenElementIdentifierMappings<RelationshipType> getRelationshipTypeTokens(TokenRead var1);

    protected abstract NodeProjections getNodeProjections();

    protected abstract RelationshipProjections getRelationshipProjections();

    protected Map<String, Integer> loadPropertyTokens(Map<? extends ElementIdentifier, ? extends ElementProjection> projectionMapping, TokenRead tokenRead) {
        return projectionMapping.values().stream().flatMap(projections -> projections.properties().stream()).collect(Collectors.toMap(PropertyMapping::neoPropertyKey, propertyMapping -> propertyMapping.neoPropertyKey() != null ? tokenRead.propertyKey(propertyMapping.neoPropertyKey()) : -1, (sameKey1, sameKey2) -> sameKey1));
    }

    @NotNull
    protected Map<RelationshipType, Long> getRelationshipCountsByType(Read dataRead, TokenElementIdentifierMappings<NodeLabel> labelTokenNodeLabelMappings, TokenElementIdentifierMappings<RelationshipType> typeTokenRelTypeMappings) {
        HashMap<RelationshipType, Long> relationshipCountsByType = new HashMap<RelationshipType, Long>();
        typeTokenRelTypeMappings.forEach((typeToken, relationshipTypes) -> {
            if (typeToken == -1 && relationshipTypes == null) {
                relationshipTypes = Collections.singletonList(RelationshipType.ALL_RELATIONSHIPS);
            }
            relationshipTypes.forEach(relationshipType -> {
                if (typeToken != -2) {
                    long numberOfRelationships = labelTokenNodeLabelMappings.keyStream().mapToLong(labelToken -> GraphDimensionsReader.relCountUpperBoundForLabelAndType(dataRead, labelToken, typeToken)).sum();
                    relationshipCountsByType.put((RelationshipType)relationshipType, numberOfRelationships);
                }
            });
        });
        return relationshipCountsByType;
    }

    private static long relCountUpperBoundForLabelAndType(Read dataRead, int labelId, int id) {
        return Math.max(dataRead.countsForRelationshipWithoutTxState(labelId, id, -1), dataRead.countsForRelationshipWithoutTxState(-1, id, labelId));
    }

    static class TokenElementIdentifierMappings<T extends ElementIdentifier> {
        private final IntObjectMap<List<T>> mappings;
        private final int allToken;

        TokenElementIdentifierMappings(int allToken) {
            this.allToken = allToken;
            this.mappings = new IntObjectHashMap();
        }

        LongSet keys() {
            LongHashSet keySet = new LongHashSet(this.mappings.keys().size());
            boolean allNodes = StreamSupport.stream(this.mappings.keys().spliterator(), false).allMatch(cursor -> cursor.value == this.allToken);
            if (!allNodes) {
                StreamSupport.stream(this.mappings.keys().spliterator(), false).forEach(arg_0 -> TokenElementIdentifierMappings.lambda$keys$1((LongSet)keySet, arg_0));
            }
            return keySet;
        }

        Stream<Integer> keyStream() {
            return this.keys().isEmpty() ? Stream.of(Integer.valueOf(this.allToken)) : StreamSupport.stream(this.keys().spliterator(), false).map(cursor -> (int)cursor.value);
        }

        void forEach(BiConsumer<Integer, List<T>> consumer) {
            this.keyStream().forEach((? super T key) -> consumer.accept((Integer)key, (List)this.mappings.get(key.intValue())));
        }

        IntObjectMap<List<T>> mappings() {
            return this.mappings;
        }

        void put(int key, T value) {
            if (!this.mappings.containsKey(key)) {
                this.mappings.put(key, new ArrayList());
            }
            ((List)this.mappings.get(key)).add(value);
        }

        private static /* synthetic */ void lambda$keys$1(LongSet keySet, IntCursor cursor) {
            keySet.add((long)cursor.value);
        }
    }
}

