/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.concurrency.ConcurrencyValidatorService;
import org.neo4j.gds.config.ConcurrencyConfig;

public interface WriteConfig
extends ConcurrencyConfig {
    public static final String WRITE_CONCURRENCY_KEY = "writeConcurrency";

    @Value.Default
    @Configuration.Key(value="writeConcurrency")
    default public int writeConcurrency() {
        return this.concurrency();
    }

    @Value.Check
    default public void validateWriteConcurrency() {
        ConcurrencyValidatorService.validator().validate(this.writeConcurrency(), WRITE_CONCURRENCY_KEY, 4);
    }

    @Configuration.GraphStoreValidationCheck
    @Value.Default
    default public void validateGraphIsSuitableForWrite(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        if (!graphStore.capabilities().canWriteToDatabase()) {
            throw new IllegalArgumentException("The provided graph does not support `write` execution mode.");
        }
    }
}

