/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;

public interface TargetNodePropertyConfig {
    @Configuration.ConvertWith(value="validateProperty")
    public String targetProperty();

    @Nullable
    public static String validateProperty(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)"targetProperty");
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateTargetProperty(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        String targetProperty = this.targetProperty();
        if (targetProperty != null && !graphStore.hasNodeProperty(selectedLabels, targetProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Target property `%s` not found in graph with node properties: %s", (Object[])new Object[]{targetProperty, graphStore.nodePropertyKeys()}));
        }
    }
}

