/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ConfigNodesValidations;
import org.neo4j.gds.config.NodeConfig;
import org.neo4j.gds.utils.StringFormatting;

public interface TargetNodeConfig
extends NodeConfig {
    public static final String TARGET_NODE_KEY = "targetNode";

    @Configuration.ConvertWith(value="org.neo4j.gds.config.TargetNodeConfig#parseTargetNodeId")
    public long targetNode();

    public static long parseTargetNodeId(Object input) {
        return NodeConfig.parseNodeId(input, TARGET_NODE_KEY);
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateTargetNode(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        long targetNodeId = this.targetNode();
        if (ConfigNodesValidations.labelFilteredGraphNotContainsNode(selectedLabels, graphStore.nodes(), targetNodeId)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Target node does not exist in the in-memory graph%s: `%d`", (Object[])new Object[]{ConfigNodesValidations.nodeLabelFilterDescription(selectedLabels, graphStore), targetNodeId}));
        }
    }
}

