/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ConfigNodesValidations;

public interface SourceNodesConfig {
    @Value.Default
    @Configuration.ConvertWith(value="org.neo4j.gds.config.NodeIdsParser#parseNodeIds")
    default public List<Long> sourceNodes() {
        return Collections.emptyList();
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateSourceLabels(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ConfigNodesValidations.validateNodes(graphStore, this.sourceNodes(), selectedLabels, "Source");
    }
}

