/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ConfigNodesValidations;
import org.neo4j.gds.config.NodeConfig;
import org.neo4j.gds.utils.StringFormatting;

public interface SourceNodeConfig
extends NodeConfig {
    public static final String SOURCE_NODE_KEY = "sourceNode";

    @Configuration.ConvertWith(value="org.neo4j.gds.config.SourceNodeConfig#parseSourceNodeId")
    public long sourceNode();

    public static long parseSourceNodeId(Object input) {
        return NodeConfig.parseNodeId(input, SOURCE_NODE_KEY);
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateSourceNode(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        long sourceNodeId = this.sourceNode();
        if (ConfigNodesValidations.labelFilteredGraphNotContainsNode(selectedLabels, graphStore.nodes(), sourceNodeId)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Source node does not exist in the in-memory graph%s: `%d`", (Object[])new Object[]{ConfigNodesValidations.nodeLabelFilterDescription(selectedLabels, graphStore), sourceNodeId}));
        }
    }
}

