/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;

public interface SeedConfig {
    public static final String SEED_PROPERTY_KEY = "seedProperty";

    @Value.Default
    @Configuration.ConvertWith(value="validatePropertyName")
    @Configuration.Key(value="seedProperty")
    @Nullable
    default public String seedProperty() {
        return null;
    }

    @Configuration.Ignore
    default public boolean isIncremental() {
        return this.seedProperty() != null;
    }

    @Nullable
    public static String validatePropertyName(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)SEED_PROPERTY_KEY);
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateSeedProperty(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        String seedProperty = this.seedProperty();
        if (seedProperty != null && !graphStore.hasNodeProperty(selectedLabels, seedProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Seed property `%s` not found in graph with node properties: %s", (Object[])new Object[]{seedProperty, graphStore.nodePropertyKeys().stream().sorted().collect(Collectors.toList())}));
        }
    }
}

