/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public interface RelationshipWeightConfig {
    public static final String RELATIONSHIP_WEIGHT_PROPERTY = "relationshipWeightProperty";

    public Optional<String> relationshipWeightProperty();

    @Value.Derived
    @Configuration.Ignore
    default public boolean hasRelationshipWeightProperty() {
        return this.relationshipWeightProperty().isPresent();
    }

    @Value.Check
    default public void validateRelationshipWeightProperty() {
        this.relationshipWeightProperty().ifPresent(input -> StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)RELATIONSHIP_WEIGHT_PROPERTY));
    }

    @Configuration.GraphStoreValidationCheck
    @Value.Default
    default public void relationshipWeightValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightProperty().ifPresent(weightProperty -> {
            Set relTypesWithoutProperty = selectedRelationshipTypes.stream().filter(relType -> !graphStore.hasRelationshipProperty((RelationshipType)relType, (String)weightProperty)).collect(Collectors.toSet());
            if (!relTypesWithoutProperty.isEmpty()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Relationship weight property `%s` not found in relationship types %s. Properties existing on all relationship types: %s", (Object[])new Object[]{weightProperty, StringJoining.join(relTypesWithoutProperty.stream().map(ElementIdentifier::name)), StringJoining.join(graphStore.relationshipPropertyKeys(selectedRelationshipTypes))}));
            }
        });
    }
}

