/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AbstractNodeProjections;
import org.neo4j.gds.AbstractRelationshipProjections;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.beta.generator.RelationshipDistribution;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.RandomGraphGeneratorConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;

public final class RandomGraphGeneratorConfigImpl
implements RandomGraphGeneratorConfig {
    private long nodeCount;
    private long averageDegree;
    private Aggregation aggregation;
    private Orientation orientation;
    private boolean allowSelfLoops;
    private RelationshipDistribution relationshipDistribution;
    @Nullable
    private Long relationshipSeed;
    private Map<String, Object> relationshipProperty;
    private NodeProjections nodeProjections;
    private RelationshipProjections relationshipProjections;
    private String username;
    private String graphName;
    private int readConcurrency;
    private long relationshipCount;
    private ZonedDateTime creationTime;
    private boolean validateRelationships;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private JobId jobId;

    public RandomGraphGeneratorConfigImpl(long nodeCount, long averageDegree, @NotNull String username, @NotNull String graphName, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.nodeCount = nodeCount;
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.averageDegree = averageDegree;
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.aggregation = (Aggregation)CypherMapWrapper.failOnNull((String)"aggregation", (Object)Aggregation.parse((Object)config.getChecked("aggregation", (Object)RandomGraphGeneratorConfig.super.aggregation(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.orientation = (Orientation)CypherMapWrapper.failOnNull((String)"orientation", (Object)Orientation.parse((Object)config.getChecked("orientation", (Object)RandomGraphGeneratorConfig.super.orientation(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.allowSelfLoops = config.getBool("allowSelfLoops", RandomGraphGeneratorConfig.super.allowSelfLoops());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipDistribution = (RelationshipDistribution)((Object)CypherMapWrapper.failOnNull((String)"relationshipDistribution", (Object)((Object)RelationshipDistribution.parse(config.getChecked("relationshipDistribution", (Object)RandomGraphGeneratorConfig.super.relationshipDistribution(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipSeed = (Long)config.getChecked("relationshipSeed", (Object)RandomGraphGeneratorConfig.super.relationshipSeed(), Long.class);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipProperty = (Map)CypherMapWrapper.failOnNull((String)"relationshipProperty", (Object)((Map)config.getChecked("relationshipProperty", RandomGraphGeneratorConfig.super.relationshipProperty(), Map.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeProjections = (NodeProjections)CypherMapWrapper.failOnNull((String)"nodeProjections", (Object)((NodeProjections)config.getChecked("nodeProjections", (Object)RandomGraphGeneratorConfig.super.nodeProjections(), NodeProjections.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipProjections = (RelationshipProjections)CypherMapWrapper.failOnNull((String)"relationshipProjections", (Object)((RelationshipProjections)config.getChecked("relationshipProjections", (Object)RandomGraphGeneratorConfig.super.relationshipProjections(), RelationshipProjections.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = GraphProjectConfig.validateName((String)CypherMapWrapper.failOnNull((String)"graphName", (Object)graphName));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.readConcurrency = config.getInt("readConcurrency", RandomGraphGeneratorConfig.super.readConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipCount = config.getLong("relationshipCount", RandomGraphGeneratorConfig.super.relationshipCount());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.creationTime = (ZonedDateTime)CypherMapWrapper.failOnNull((String)"creationTime", (Object)((ZonedDateTime)config.getChecked("creationTime", (Object)RandomGraphGeneratorConfig.super.creationTime(), ZonedDateTime.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateRelationships = config.getBool("validateRelationships", RandomGraphGeneratorConfig.super.validateRelationships());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapWrapper.failOnNull((String)"username", (Object)BaseConfig.trim((Optional)config.getOptional("username", String.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", RandomGraphGeneratorConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapWrapper.failOnNull((String)"jobId", (Object)JobId.parse(config.getChecked("jobId", (Object)RandomGraphGeneratorConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateReadConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public long nodeCount() {
        return this.nodeCount;
    }

    @Override
    public long averageDegree() {
        return this.averageDegree;
    }

    @Override
    public Aggregation aggregation() {
        return this.aggregation;
    }

    @Override
    public Orientation orientation() {
        return this.orientation;
    }

    @Override
    public boolean allowSelfLoops() {
        return this.allowSelfLoops;
    }

    @Override
    public RelationshipDistribution relationshipDistribution() {
        return this.relationshipDistribution;
    }

    @Override
    @Nullable
    public Long relationshipSeed() {
        return this.relationshipSeed;
    }

    @Override
    public Map<String, Object> relationshipProperty() {
        return this.relationshipProperty;
    }

    @Override
    public NodeProjections nodeProjections() {
        return this.nodeProjections;
    }

    @Override
    public RelationshipProjections relationshipProjections() {
        return this.relationshipProjections;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public int readConcurrency() {
        return this.readConcurrency;
    }

    @Override
    public long relationshipCount() {
        return this.relationshipCount;
    }

    @Override
    public ZonedDateTime creationTime() {
        return this.creationTime;
    }

    @Override
    public boolean validateRelationships() {
        return this.validateRelationships;
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("aggregation", "orientation", "allowSelfLoops", "relationshipDistribution", "relationshipSeed", "relationshipProperty", "nodeProjections", "relationshipProjections", "readConcurrency", "relationshipCount", "creationTime", "validateRelationships", "username", "sudo", "jobId");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("aggregation", Aggregation.toString((Aggregation)this.aggregation()));
        map.put("orientation", Orientation.toString((Orientation)this.orientation()));
        map.put("allowSelfLoops", this.allowSelfLoops());
        map.put("relationshipDistribution", RelationshipDistribution.toString(this.relationshipDistribution()));
        map.put("relationshipSeed", this.relationshipSeed());
        map.put("relationshipProperty", this.relationshipProperty());
        map.put("nodeProjections", AbstractNodeProjections.toObject((AbstractNodeProjections)this.nodeProjections()));
        map.put("relationshipProjections", AbstractRelationshipProjections.toObject((AbstractRelationshipProjections)this.relationshipProjections()));
        map.put("readConcurrency", this.readConcurrency());
        map.put("relationshipCount", this.relationshipCount());
        map.put("creationTime", this.creationTime());
        map.put("validateRelationships", this.validateRelationships());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("jobId", JobId.asString(this.jobId()));
        return map;
    }

    @Override
    public JobId jobId() {
        return this.jobId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        private long nodeCount;
        private long averageDegree;
        @NotNull
        private String username;
        @NotNull
        private String graphName;

        public Builder nodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public Builder averageDegree(long averageDegree) {
            this.averageDegree = averageDegree;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public Builder aggregation(Object aggregation) {
            this.config.put("aggregation", aggregation);
            return this;
        }

        public Builder orientation(Object orientation) {
            this.config.put("orientation", orientation);
            return this;
        }

        public Builder allowSelfLoops(boolean allowSelfLoops) {
            this.config.put("allowSelfLoops", allowSelfLoops);
            return this;
        }

        public Builder relationshipDistribution(Object relationshipDistribution) {
            this.config.put("relationshipDistribution", relationshipDistribution);
            return this;
        }

        public Builder relationshipSeed(Long relationshipSeed) {
            this.config.put("relationshipSeed", relationshipSeed);
            return this;
        }

        public Builder relationshipProperty(Map<String, Object> relationshipProperty) {
            this.config.put("relationshipProperty", relationshipProperty);
            return this;
        }

        public Builder nodeProjections(NodeProjections nodeProjections) {
            this.config.put("nodeProjections", nodeProjections);
            return this;
        }

        public Builder relationshipProjections(RelationshipProjections relationshipProjections) {
            this.config.put("relationshipProjections", relationshipProjections);
            return this;
        }

        public Builder readConcurrency(int readConcurrency) {
            this.config.put("readConcurrency", readConcurrency);
            return this;
        }

        public Builder relationshipCount(long relationshipCount) {
            this.config.put("relationshipCount", relationshipCount);
            return this;
        }

        public Builder creationTime(ZonedDateTime creationTime) {
            this.config.put("creationTime", creationTime);
            return this;
        }

        public Builder validateRelationships(boolean validateRelationships) {
            this.config.put("validateRelationships", validateRelationships);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public RandomGraphGeneratorConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new RandomGraphGeneratorConfigImpl(this.nodeCount, this.averageDegree, this.username, this.graphName, config);
        }
    }
}

