/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.beta.generator.RelationshipDistribution;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.RandomGraphGeneratorConfigImpl;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;

@ValueClass
@Configuration
public interface RandomGraphGeneratorConfig
extends GraphProjectConfig {
    public static final String RELATIONSHIP_SEED_KEY = "relationshipSeed";
    public static final String RELATIONSHIP_PROPERTY_KEY = "relationshipProperty";
    public static final String RELATIONSHIP_DISTRIBUTION_KEY = "relationshipDistribution";
    public static final String RELATIONSHIP_PROPERTY_NAME_KEY = "name";
    public static final String RELATIONSHIP_PROPERTY_TYPE_KEY = "type";
    public static final String RELATIONSHIP_PROPERTY_MIN_KEY = "min";
    public static final String RELATIONSHIP_PROPERTY_MAX_KEY = "max";
    public static final String RELATIONSHIP_PROPERTY_VALUE_KEY = "value";

    @Override
    @Configuration.Parameter
    public long nodeCount();

    @Configuration.Parameter
    public long averageDegree();

    @Value.Default
    @Configuration.ConvertWith(value="org.neo4j.gds.core.Aggregation#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.core.Aggregation#toString")
    default public Aggregation aggregation() {
        return Aggregation.NONE;
    }

    @Value.Default
    @Configuration.ConvertWith(value="org.neo4j.gds.Orientation#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.Orientation#toString")
    default public Orientation orientation() {
        return Orientation.NATURAL;
    }

    @Value.Default
    default public boolean allowSelfLoops() {
        return false;
    }

    @Value.Default
    @Configuration.ConvertWith(value="org.neo4j.gds.beta.generator.RelationshipDistribution#parse")
    @Configuration.ToMapValue(value="org.neo4j.gds.beta.generator.RelationshipDistribution#toString")
    default public RelationshipDistribution relationshipDistribution() {
        return RelationshipDistribution.UNIFORM;
    }

    @Value.Default
    @Nullable
    default public Long relationshipSeed() {
        return null;
    }

    default public Map<String, Object> relationshipProperty() {
        return Collections.emptyMap();
    }

    @Value.Default
    @Configuration.ToMapValue(value="org.neo4j.gds.AbstractNodeProjections#toObject")
    default public NodeProjections nodeProjections() {
        return NodeProjections.builder().putProjection(NodeLabel.of((String)(this.nodeCount() + "_Nodes")), NodeProjection.of((String)(this.nodeCount() + "_Nodes"))).build();
    }

    @Value.Default
    @Configuration.Ignore
    default public RelationshipType relationshipType() {
        return RelationshipType.of((String)"REL");
    }

    @Value.Default
    @Configuration.ToMapValue(value="org.neo4j.gds.AbstractRelationshipProjections#toObject")
    default public RelationshipProjections relationshipProjections() {
        return RelationshipProjections.builder().putProjection(this.relationshipType(), RelationshipProjection.of((String)this.relationshipType().name, (Orientation)this.orientation(), (Aggregation)this.aggregation())).build();
    }

    @Override
    @Configuration.Ignore
    default public GraphStoreFactory.Supplier graphStoreFactory() {
        throw new UnsupportedOperationException("RandomGraphGeneratorConfig requires explicit graph generation.");
    }

    @Override
    @Configuration.Ignore
    default public <R> R accept(GraphProjectConfig.Cases<R> visitor) {
        return visitor.random(this);
    }

    @Value.Derived
    @Configuration.Ignore
    default public Set<String> outputFieldDenylist() {
        return Set.of("readConcurrency", "nodeCount", "relationshipCount", "validateRelationships");
    }

    public static RandomGraphGeneratorConfig of(String username, String graphName, long nodeCount, long averageDegree, CypherMapWrapper config) {
        return new RandomGraphGeneratorConfigImpl(nodeCount, averageDegree, username, graphName, config);
    }

    public static enum AllowSelfLoops {
        YES(true),
        NO(false);

        private final boolean value;

        private AllowSelfLoops(boolean value) {
            this.value = value;
        }

        public static AllowSelfLoops of(boolean value) {
            return value ? YES : NO;
        }

        public boolean value() {
            return this.value;
        }
    }
}

