/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public interface NodeWeightConfig {
    @Value.Default
    @Configuration.ConvertWith(value="validatePropertyName")
    @Nullable
    default public String nodeWeightProperty() {
        return null;
    }

    @Nullable
    public static String validatePropertyName(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)"nodeWeightProperty");
    }

    @Configuration.GraphStoreValidationCheck
    @Value.Default
    default public void nodeWeightValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        String weightProperty = this.nodeWeightProperty();
        if (weightProperty != null && !graphStore.hasNodeProperty(selectedLabels, weightProperty)) {
            List labelsWithMissingProperty = selectedLabels.stream().filter(label -> !graphStore.nodePropertyKeys((NodeLabel)label).contains(weightProperty)).map(ElementIdentifier::name).collect(Collectors.toList());
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node weight property `%s` is not present for all requested labels. Requested labels: %s. Labels without the property key: %s. Properties available on all requested labels: %s", (Object[])new Object[]{weightProperty, StringJoining.join(selectedLabels.stream().map(ElementIdentifier::name)), StringJoining.join(labelsWithMissingProperty), StringJoining.join(graphStore.nodePropertyKeys(selectedLabels))}));
        }
    }
}

