/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Node;

public interface NodeIdsParser {
    public static List<Long> parseNodeIds(Object input) {
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        if (input instanceof List) {
            ((List)input).forEach(e -> nodeIds.add(NodeIdsParser.parseNodeId(e)));
        } else {
            nodeIds.add(NodeIdsParser.parseNodeId(input));
        }
        return nodeIds;
    }

    public static Long parseNodeId(Object input) {
        if (input instanceof Node) {
            return ((Node)input).getId();
        }
        if (input instanceof Number) {
            return ((Number)input).longValue();
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected List of Nodes or Numbers for `sourceNodes`. Got %s.", (Object[])new Object[]{input.getClass().getSimpleName()}));
    }
}

