/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.config;

import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.MutateConfig;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;

public interface MutateRelationshipConfig
extends MutateConfig {
    public static final String MUTATE_RELATIONSHIP_TYPE_KEY = "mutateRelationshipType";

    @Configuration.ConvertWith(value="validateTypeIdentifier")
    public String mutateRelationshipType();

    @Nullable
    public static String validateTypeIdentifier(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)MUTATE_RELATIONSHIP_TYPE_KEY);
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateMutateRelationships(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        String mutateRelationshipType = this.mutateRelationshipType();
        if (mutateRelationshipType != null && graphStore.hasRelationshipType(RelationshipType.of((String)mutateRelationshipType))) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Relationship type `%s` already exists in the in-memory graph.", (Object[])new Object[]{mutateRelationshipType}));
        }
    }
}

